<?php

namespace App\Console\Commands;

use App\Models\ActivityLog;
use App\Models\Setting;
use Illuminate\Console\Command;
use Carbon\Carbon;

class CleanActivityLogs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'activity-logs:clean';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean old activity logs based on retention days setting';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $retentionDays = (int)Setting::get('activity_logs_retention_days', 30);
        
        if ($retentionDays <= 0) {
            $this->info('Activity logs auto-clean is disabled (retention days is 0 or less).');
            return 0;
        }

        $cutoffDate = Carbon::now()->subDays($retentionDays);
        
        $this->info("Cleaning activity logs older than {$retentionDays} days (before {$cutoffDate->format('Y-m-d H:i:s')})...");
        
        $deleted = ActivityLog::where('created_at', '<', $cutoffDate)->delete();
        
        $this->info("Successfully deleted {$deleted} activity log(s).");
        
        return 0;
    }
}



