<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\License;
use App\Models\Setting;

class ClearLicense extends Command
{
    protected $signature = 'license:clear';
    protected $description = 'حذف جميع التراخيص';

    public function handle()
    {
        $count = License::count();
        
        License::truncate();
        Setting::where('key', 'like', 'license%')->delete();
        
        $this->info("تم حذف {$count} ترخيص بنجاح!");
        $this->info("تم حذف جميع إعدادات الترخيص!");
        
        return 0;
    }
}
