<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\TrialService;

class ResetTrial extends Command
{
    protected $signature = 'trial:reset';
    protected $description = 'إعادة تعيين الفترة التجريبية';

    public function handle(TrialService $trialService)
    {
        $trialService->resetTrial();
        $this->info('تم إعادة تعيين الفترة التجريبية بنجاح!');
        $this->info('تاريخ البداية الجديد: ' . $trialService->getStartDate()->format('Y-m-d'));
        return 0;
    }
}
