<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Setting;
use Carbon\Carbon;

class SetTrialDate extends Command
{
    protected $signature = 'trial:set-date {days?}';
    protected $description = 'تعيين تاريخ بداية الفترة التجريبية (قبل X يوم)';

    public function handle()
    {
        $days = $this->argument('days') ?? 21; // افتراضياً 21 يوم (منتهية)
        
        $startDate = Carbon::now()->subDays($days);
        
        Setting::set('trial_start_date', $startDate->format('Y-m-d'));
        
        // مسح Cache للتأكد من تحديث القيمة
        \Illuminate\Support\Facades\Cache::forget('setting.trial_start_date');
        
        $endDate = $startDate->copy()->addDays(20);
        $now = Carbon::now();
        $daysRemaining = $now->greaterThan($endDate) ? 0 : max(0, $now->diffInDays($endDate) + 1);
        
        $this->info("تم تعيين تاريخ البداية: {$startDate->format('Y-m-d')}");
        $this->info("تاريخ الانتهاء: {$endDate->format('Y-m-d')}");
        $this->info("الأيام المتبقية: {$daysRemaining}");
        
        if ($daysRemaining <= 0) {
            $this->warn("⚠️  الفترة التجريبية منتهية!");
        }
        
        return 0;
    }
}
