<?php

namespace App\Console\Commands;

use App\Services\LicenseDatabaseService;
use Illuminate\Console\Command;

class ShowLicenseDbInfo extends Command
{
    protected $signature = 'license:db-info';

    protected $description = 'عرض معلومات قاعدة بيانات التراخيص';

    public function handle()
    {
        $licenseDb = app(LicenseDatabaseService::class);
        $info = $licenseDb->getDatabaseInfo();
        $allLicenses = $licenseDb->all();

        $this->info('معلومات قاعدة بيانات التراخيص');
        $this->newLine();

        $this->table(
            ['المعلومة', 'القيمة'],
            [
                ['المسار', $info['path']],
                ['موجود', $info['exists'] ? '✅ نعم' : '❌ لا'],
                ['الحجم', $info['exists'] ? $this->formatBytes($info['size']) : '0 B'],
                ['الصلاحيات', $info['permissions'] ?? 'غير محدد'],
                ['محمي', $info['protected'] ?? false ? '✅ نعم' : '❌ لا'],
                ['البيانات مشفرة', $info['encrypted_data'] ?? false ? '✅ نعم' : '❌ لا'],
                ['كلمة المرور معينة', $info['password_set'] ?? false ? '✅ نعم' : '❌ لا'],
                ['عدد التراخيص', count($allLicenses)],
            ]
        );

        $this->newLine();
        $this->info('📋 إحصائيات التراخيص:');
        
        $statusCounts = [];
        foreach ($allLicenses as $license) {
            $status = $license['status'] ?? 'unknown';
            $statusCounts[$status] = ($statusCounts[$status] ?? 0) + 1;
        }

        $statusData = [];
        foreach ($statusCounts as $status => $count) {
            $statusData[] = [$this->getStatusLabel($status), $count];
        }

        if (!empty($statusData)) {
            $this->table(['الحالة', 'العدد'], $statusData);
        }

        return 0;
    }

    protected function formatBytes($bytes, $precision = 2): string
    {
        $units = ['B', 'KB', 'MB', 'GB'];
        
        for ($i = 0; $bytes > 1024 && $i < count($units) - 1; $i++) {
            $bytes /= 1024;
        }
        
        return round($bytes, $precision) . ' ' . $units[$i];
    }

    protected function getStatusLabel($status): string
    {
        $labels = [
            'pending' => '⏳ في الانتظار',
            'active' => '✅ مفعّل',
            'expired' => '❌ منتهي',
            'suspended' => '🚫 معلّق',
        ];

        return $labels[$status] ?? $status;
    }
}






