<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class GeneratedLicensesExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithStyles, WithColumnWidths
{
    protected $licenses;

    public function __construct(array $licenses)
    {
        $this->licenses = collect($licenses);
    }

    public function collection()
    {
        return $this->licenses;
    }

    public function headings(): array
    {
        return [
            'الرقم / Number',
            'License Key',
            'Serial Number',
            'تاريخ الانتهاء / Expires At',
            'عدد المستخدمين / Max Users',
            'الحالة / Status',
        ];
    }

    public function map($license): array
    {
        return [
            $license['number'] ?? '',
            $license['license_key'] ?? '',
            $license['serial_number'] ?? '',
            $license['expires_at'] ?? 'دائم / Permanent',
            $license['max_users'] ?? 10,
            'غير مستعمل / Not Used',
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 12,  // Number
            'B' => 25,  // License Key
            'C' => 20,  // Serial Number
            'D' => 20,  // Expires At
            'E' => 18,  // Max Users
            'F' => 20,  // Status
        ];
    }

    public function styles(Worksheet $sheet)
    {
        // تنسيق رأس الجدول
        $sheet->getStyle('A1:F1')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => 'FFFFFF'],
                'size' => 12,
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => '4472C4'],
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
        ]);

        // تحديد ارتفاع الصف الأول
        $sheet->getRowDimension(1)->setRowHeight(25);

        // تطبيق التنسيق على جميع الصفوف
        $highestRow = $sheet->getHighestRow();
        if ($highestRow > 1) {
            $sheet->getStyle('A2:F' . $highestRow)->applyFromArray([
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'FFFFFF'],
                ],
                'alignment' => [
                    'vertical' => Alignment::VERTICAL_CENTER,
                ],
            ]);
        }

        // إضافة حدود للخلايا
        $sheet->getStyle('A1:F' . $highestRow)->applyFromArray([
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['rgb' => 'CCCCCC'],
                ],
            ],
        ]);

        // تجميد الصف الأول
        if ($highestRow > 1) {
            $sheet->freezePane('A2');
        }

        return $sheet;
    }
}

