<?php

namespace App\Exports;

use App\Models\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ProductsExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    public function collection()
    {
        return Product::with('category')->get();
    }

    public function headings(): array
    {
        return [
            'SKU',
            'Barcode',
            'Name',
            'Name (AR)',
            'Brand',
            'Category',
            'Unit',
            'Purchase Price',
            'Selling Price',
            'Tax Rate',
            'Stock',
            'Reorder Level',
        ];
    }

    public function map($product): array
    {
        return [
            $product->sku,
            $product->barcode,
            $product->name,
            $product->name_ar,
            $product->brand,
            $product->category?->name,
            $product->unit,
            $product->purchase_price,
            $product->selling_price,
            $product->tax_rate,
            $product->stock_quantity,
            $product->reorder_level,
        ];
    }
}

