<?php

namespace App\Exports;

use App\Models\PurchaseInvoice;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class PurchaseInvoicesExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $purchaseInvoices;

    public function __construct($purchaseInvoices = null)
    {
        $this->purchaseInvoices = $purchaseInvoices ?? PurchaseInvoice::with(['supplier', 'user'])->get();
    }

    public function collection()
    {
        return $this->purchaseInvoices;
    }

    public function headings(): array
    {
        return [
            'Invoice Number',
            'Purchase Date',
            'Supplier',
            'Status',
            'Subtotal',
            'Tax',
            'Discount',
            'Total Amount',
            'Amount Paid',
            'Amount Remaining',
            'Notes',
            'Created By',
        ];
    }

    public function map($purchaseInvoice): array
    {
        return [
            $purchaseInvoice->invoice_number,
            $purchaseInvoice->purchase_date->format('Y-m-d'),
            $purchaseInvoice->supplier->name ?? '',
            $purchaseInvoice->status,
            $purchaseInvoice->subtotal,
            $purchaseInvoice->tax,
            $purchaseInvoice->discount,
            $purchaseInvoice->total_amount,
            $purchaseInvoice->amount_paid,
            $purchaseInvoice->amount_remaining,
            $purchaseInvoice->notes ?? '',
            $purchaseInvoice->user->name ?? '',
        ];
    }
}

