<?php

namespace App\Exports;

use App\Models\Treasury;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class TreasuryExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $treasuries;

    public function __construct($treasuries)
    {
        $this->treasuries = $treasuries;
    }

    public function collection()
    {
        return $this->treasuries;
    }

    public function headings(): array
    {
        return [
            trans('messages.date'),
            trans('messages.type'),
            trans('messages.reference_type'),
            trans('messages.amount'),
            trans('messages.payment_method'),
            trans('messages.description'),
            trans('messages.created_by'),
        ];
    }

    public function map($treasury): array
    {
        return [
            $treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '-',
            trans('messages.' . $treasury->type),
            trans('messages.' . $treasury->reference_type),
            number_format($treasury->amount, 2),
            trans('messages.' . $treasury->payment_method),
            $treasury->description ?? '',
            $treasury->creator->name ?? '',
        ];
    }
}
