<?php

if (!function_exists('currency_symbol')) {
    function currency_symbol()
    {
        return \App\Models\Setting::get('currency', '$');
    }
}

if (!function_exists('format_currency')) {
    function format_currency($amount, $decimals = 2)
    {
        return number_format($amount, $decimals) . ' ' . currency_symbol();
    }
}

if (!function_exists('user_can')) {
    /**
     * Check if the authenticated user has a permission
     */
    function user_can($permission)
    {
        if (!auth()->check()) {
            return false;
        }
        return auth()->user()->can($permission);
    }
}

if (!function_exists('format_file_size')) {
    function format_file_size($bytes)
    {
        if ($bytes >= 1073741824) {
            return number_format($bytes / 1073741824, 2) . ' GB';
        } elseif ($bytes >= 1048576) {
            return number_format($bytes / 1048576, 2) . ' MB';
        } elseif ($bytes >= 1024) {
            return number_format($bytes / 1024, 2) . ' KB';
        } else {
            return $bytes . ' B';
        }
    }
}

