<?php

namespace App\Http\Controllers;

use App\Models\StockAlert;
use App\Models\Setting;
use Illuminate\Http\Request;

class StockAlertController extends Controller
{
    public function index(Request $request)
    {
        $query = StockAlert::with(['product.category', 'creator']);

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        if ($request->filled('search')) {
            $search = $request->search;
            $query->whereHas('product', function ($q) use ($search) {
                $q->where('name', 'like', "%{$search}%")
                  ->orWhere('sku', 'like', "%{$search}%");
            });
        }

        $itemsPerPage = Setting::getItemsPerPage(20);
        $alerts = $query->latest()->paginate($itemsPerPage)->appends($request->query());

        return view('stock-alerts.index', compact('alerts'));
    }

    public function acknowledge(StockAlert $stockAlert)
    {
        $stockAlert->acknowledge();
        return back()->with('success', trans('messages.alert_acknowledged'));
    }

    public function resolve(StockAlert $stockAlert)
    {
        $stockAlert->resolve();
        return back()->with('success', trans('messages.alert_resolved'));
    }

    public function destroy(StockAlert $stockAlert)
    {
        $stockAlert->delete();
        return back()->with('success', trans('messages.alert_deleted'));
    }
}
