<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\Response;

class StorageController extends Controller
{
    /**
     * Serve files from storage/app/public without symlink
     */
    public function serve(Request $request, $path)
    {
        // Decode each segment of the path separately
        $segments = explode('/', $path);
        $decodedSegments = array_map('rawurldecode', $segments);
        $path = implode('/', $decodedSegments);
        
        // Security: Prevent directory traversal
        $path = str_replace('..', '', $path);
        $path = ltrim($path, '/');
        
        // Check if file exists
        if (!Storage::disk('public')->exists($path)) {
            abort(404, 'File not found: ' . $path);
        }
        
        // Get file content and mime type
        $file = Storage::disk('public')->get($path);
        $mimeType = Storage::disk('public')->mimeType($path);
        
        // Return file with proper headers
        return response($file, 200)
            ->header('Content-Type', $mimeType)
            ->header('Cache-Control', 'public, max-age=31536000');
    }
}

