<?php

namespace App\Http\Controllers;

use App\Services\TrialService;
use Illuminate\Http\Request;

class TrialController extends Controller
{
    protected $trialService;

    public function __construct(TrialService $trialService)
    {
        $this->trialService = $trialService;
    }

    /**
     * عرض صفحة انتهاء الفترة التجريبية
     */
    public function expired()
    {
        $trialInfo = $this->trialService->getTrialInfo();
        
        return view('trial.expired', compact('trialInfo'));
    }

    /**
     * صفحة اختبار - تعديل تاريخ البداية
     */
    public function test(Request $request)
    {
        $days = $request->input('days', 21); // افتراضياً 21 يوم (منتهية)
        
        $this->trialService->setStartDate($days);
        
        $trialInfo = $this->trialService->getTrialInfo();
        
        return view('trial.test', compact('trialInfo', 'days'));
    }

    /**
     * إعادة تعيين الفترة التجريبية
     */
    public function reset()
    {
        $this->trialService->resetTrial();
        
        return redirect()->back()->with('success', 'تم إعادة تعيين الفترة التجريبية بنجاح!');
    }

    /**
     * صفحة اختبار التحقق من النظام
     */
    public function check()
    {
        $trialInfo = $this->trialService->getTrialInfo();
        $licenseService = app(\App\Services\LicenseService::class);
        $hasLicense = $licenseService->verifyLocal();
        
        return response()->json([
            'trial_info' => $trialInfo,
            'has_license' => $hasLicense,
            'should_block' => !$hasLicense && $trialInfo['is_expired'],
        ]);
    }
}
