<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'action',
        'model_type',
        'model_id',
        'old_values',
        'new_values',
        'user_id',
        'ip_address',
        'user_agent',
    ];

    protected function casts(): array
    {
        return [
            'old_values' => 'array',
            'new_values' => 'array',
        ];
    }

    protected static function boot()
    {
        parent::boot();

        // Automatically JSON encode array values when saving (if not already encoded)
        static::saving(function ($auditLog) {
            if (is_array($auditLog->old_values)) {
                $auditLog->old_values = json_encode($auditLog->old_values);
            }
            if (is_array($auditLog->new_values)) {
                $auditLog->new_values = json_encode($auditLog->new_values);
            }
            // If already a string (JSON encoded), leave it as is
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function model()
    {
        return $this->morphTo('model');
    }
}

