<?php

namespace App\Traits;

trait ChecksPermissions
{
    /**
     * Check if user has permission, abort if not
     */
    protected function checkPermission(string $permission): void
    {
        if (!auth()->user()->can($permission)) {
            abort(403, trans('messages.unauthorized_action'));
        }
    }

    /**
     * Check if user has any of the given permissions
     */
    protected function checkAnyPermission(array $permissions): void
    {
        $hasPermission = false;
        foreach ($permissions as $permission) {
            if (auth()->user()->can($permission)) {
                $hasPermission = true;
                break;
            }
        }

        if (!$hasPermission) {
            abort(403, trans('messages.unauthorized_action'));
        }
    }
}

