<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductFactory extends Factory
{
    public function definition(): array
    {
        return [
            'sku' => 'PROD' . str_pad($this->faker->unique()->numberBetween(1, 9999), 4, '0', STR_PAD_LEFT),
            'barcode' => $this->faker->unique()->ean13(),
            'name' => $this->faker->words(3, true),
            'name_ar' => $this->faker->words(3, true),
            'category_id' => Category::factory(),
            'unit' => 'piece',
            'purchase_price' => $this->faker->randomFloat(2, 10, 500),
            'selling_price' => $this->faker->randomFloat(2, 15, 750),
            'tax_rate' => $this->faker->randomFloat(2, 0, 20),
            'stock_quantity' => $this->faker->numberBetween(0, 1000),
            'reorder_level' => $this->faker->numberBetween(5, 50),
            'description' => $this->faker->sentence(),
        ];
    }
}

