<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('promissory_notes', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['customer', 'supplier']); // نوع: عميل أو مورد
            $table->foreignId('customer_id')->nullable()->constrained()->nullOnDelete(); // للعملاء
            $table->foreignId('supplier_id')->nullable()->constrained()->nullOnDelete(); // للموردين
            $table->foreignId('invoice_id')->nullable()->constrained()->nullOnDelete(); // فاتورة المبيعات (اختياري)
            $table->foreignId('purchase_invoice_id')->nullable()->constrained()->nullOnDelete(); // فاتورة الشراء (اختياري)
            $table->decimal('amount', 15, 2);
            $table->string('note_number')->unique(); // رقم الكمبيالة
            $table->date('issue_date'); // تاريخ الإصدار
            $table->date('due_date'); // تاريخ الاستحقاق
            $table->enum('status', ['pending', 'due', 'paid', 'cancelled'])->default('pending');
            $table->date('paid_date')->nullable(); // تاريخ الدفع
            $table->text('notes')->nullable();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('promissory_notes');
    }
};
