<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Remove deleted_at column from all tables that have it
        $tables = [
            'users',
            'categories',
            'products',
            'customers',
            'suppliers',
            'invoices',
            'invoice_items',
            'payments',
            'purchase_invoices',
            'purchase_invoice_items',
            'supplier_payments',
            'stock_movements',
            'treasuries',
            'inventories',
            'cheques',
            'promissory_notes',
        ];

        foreach ($tables as $table) {
            if (Schema::hasTable($table) && Schema::hasColumn($table, 'deleted_at')) {
                Schema::table($table, function (Blueprint $table) {
                    $table->dropSoftDeletes();
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Re-add deleted_at column to all tables
        $tables = [
            'users',
            'categories',
            'products',
            'customers',
            'suppliers',
            'invoices',
            'invoice_items',
            'payments',
            'purchase_invoices',
            'purchase_invoice_items',
            'supplier_payments',
            'stock_movements',
            'treasuries',
            'inventories',
            'cheques',
            'promissory_notes',
        ];

        foreach ($tables as $table) {
            if (Schema::hasTable($table) && !Schema::hasColumn($table, 'deleted_at')) {
                Schema::table($table, function (Blueprint $table) {
                    $table->softDeletes();
                });
            }
        }
    }
};
