<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Electronics', 'name_ar' => 'إلكترونيات'],
            ['name' => 'Clothing', 'name_ar' => 'ملابس'],
            ['name' => 'Food & Beverages', 'name_ar' => 'طعام ومشروبات'],
            ['name' => 'Home & Garden', 'name_ar' => 'منزل وحديقة'],
            ['name' => 'Sports', 'name_ar' => 'رياضة'],
        ];

        foreach ($categories as $category) {
            Category::firstOrCreate(['name' => $category['name']], $category);
        }
    }
}

