<?php

namespace Database\Seeders;

use App\Models\Customer;
use Illuminate\Database\Seeder;

class CustomerSeeder extends Seeder
{
    public function run(): void
    {
        $customers = [
            ['name' => 'John Doe', 'email' => 'john@example.com', 'phone' => '1111111111'],
            ['name' => 'Jane Smith', 'email' => 'jane@example.com', 'phone' => '2222222222'],
            ['name' => 'Ahmed Ali', 'email' => 'ahmed@example.com', 'phone' => '3333333333'],
            ['name' => 'Fatima Hassan', 'email' => 'fatima@example.com', 'phone' => '4444444444'],
            ['name' => 'Mohammed Saleh', 'email' => 'mohammed@example.com', 'phone' => '5555555555'],
            ['name' => 'Sarah Johnson', 'email' => 'sarah@example.com', 'phone' => '6666666666'],
            ['name' => 'Omar Khaled', 'email' => 'omar@example.com', 'phone' => '7777777777'],
            ['name' => 'Layla Ahmed', 'email' => 'layla@example.com', 'phone' => '8888888888'],
            ['name' => 'David Brown', 'email' => 'david@example.com', 'phone' => '9999999999'],
            ['name' => 'Mary Wilson', 'email' => 'mary@example.com', 'phone' => '1010101010'],
        ];

        foreach ($customers as $customer) {
            Customer::firstOrCreate(['email' => $customer['email']], $customer);
        }
    }
}

