$(document).ready(function() {
    // Auto-dismiss alerts after 10 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 10000);

    // Date range validation - disable end date before start date
    function updateEndDateMin(startDateInput) {
        const startDate = $(startDateInput).val();
        const form = $(startDateInput).closest('form');
        
        // Find corresponding end date input
        let endDateInput = null;
        if ($(startDateInput).attr('name') === 'date_from' || $(startDateInput).attr('id') === 'date_from') {
            endDateInput = form.find('input[name="date_to"], input[id="date_to"]');
        } else if ($(startDateInput).attr('name') === 'start_date' || $(startDateInput).attr('id') === 'start_date') {
            endDateInput = form.find('input[name="end_date"], input[id="end_date"]');
        }
        
        if (startDate && endDateInput && endDateInput.length) {
            endDateInput.attr('min', startDate);
            // If end date is before start date, clear it
            if (endDateInput.val() && endDateInput.val() < startDate) {
                endDateInput.val('');
            }
        }
    }

    // Initialize date range validation on page load
    $('input[type="date"][name="date_from"], input[type="date"][id="date_from"], input[type="date"][name="start_date"], input[type="date"][id="start_date"]').each(function() {
        updateEndDateMin(this);
    });

    // Handle date_from and date_to pairs using event delegation
    $(document).on('change', 'input[type="date"][name="date_from"], input[type="date"][id="date_from"]', function() {
        updateEndDateMin(this);
    });

    // Handle start_date and end_date pairs using event delegation
    $(document).on('change', 'input[type="date"][name="start_date"], input[type="date"][id="start_date"]', function() {
        updateEndDateMin(this);
    });

    // Beautiful confirm modal function
    window.showConfirmModal = function(message, title, onConfirm, onCancel) {
        // Default texts
        const defaultTitle = title || 'Confirm';
        const defaultCancelText = 'Cancel';
        const defaultConfirmText = 'Confirm';

        // Create or get modal element
        let modalElement = document.getElementById('confirmModal');
        if (!modalElement) {
            modalElement = document.createElement('div');
            modalElement.id = 'confirmModal';
            modalElement.className = 'modal fade';
            modalElement.setAttribute('tabindex', '-1');
            modalElement.setAttribute('aria-labelledby', 'confirmModalLabel');
            modalElement.setAttribute('aria-hidden', 'true');
            modalElement.innerHTML = `
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content shadow-lg">
                        <div class="modal-header border-0 pb-0">
                            <h5 class="modal-title d-flex align-items-center" id="confirmModalLabel">
                                <i class="bi bi-exclamation-triangle-fill text-warning me-2" style="font-size: 1.5rem;"></i>
                                <span id="confirmModalTitle"></span>
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body pt-3">
                            <p id="confirmModalMessage" class="mb-0"></p>
                        </div>
                        <div class="modal-footer border-0 pt-0">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="confirmModalCancel">
                                <i class="bi bi-x-circle me-1"></i> <span id="confirmModalCancelText">${defaultCancelText}</span>
                            </button>
                            <button type="button" class="btn btn-primary" id="confirmModalConfirm">
                                <i class="bi bi-check-circle me-1"></i> <span id="confirmModalConfirmText">${defaultConfirmText}</span>
                            </button>
                        </div>
                    </div>
                </div>
            `;
            document.body.appendChild(modalElement);
        }

        // Set content
        document.getElementById('confirmModalTitle').textContent = defaultTitle;
        document.getElementById('confirmModalMessage').textContent = message;

        // Remove previous event listeners by cloning buttons
        const confirmBtn = document.getElementById('confirmModalConfirm');
        const cancelBtn = document.getElementById('confirmModalCancel');
        const newConfirmBtn = confirmBtn.cloneNode(true);
        const newCancelBtn = cancelBtn.cloneNode(true);
        confirmBtn.parentNode.replaceChild(newConfirmBtn, confirmBtn);
        cancelBtn.parentNode.replaceChild(newCancelBtn, cancelBtn);

        // Show modal
        const modal = new bootstrap.Modal(modalElement, {
            backdrop: true,
            keyboard: true,
            focus: true
        });

        let isConfirmed = false;

        // Handle confirm
        newConfirmBtn.addEventListener('click', function() {
            isConfirmed = true;
            modal.hide();
            if (onConfirm && typeof onConfirm === 'function') {
                setTimeout(() => onConfirm(), 100);
            }
        });

        // Handle cancel
        newCancelBtn.addEventListener('click', function() {
            isConfirmed = false;
            modal.hide();
            if (onCancel && typeof onCancel === 'function') {
                setTimeout(() => onCancel(), 100);
            }
        });

        // Handle backdrop click
        const handleHidden = function() {
            if (!isConfirmed && onCancel && typeof onCancel === 'function') {
                onCancel();
            }
            modalElement.removeEventListener('hidden.bs.modal', handleHidden);
        };
        modalElement.addEventListener('hidden.bs.modal', handleHidden);

        modal.show();
        return modal;
    };

    // Replace all onclick confirm with beautiful modal
    $(document).ready(function() {
        // Handle forms with onclick confirm
        $(document).on('submit', 'form', function(e) {
            const submitBtn = $(this).find('button[type="submit"][onclick*="confirm"], input[type="submit"][onclick*="confirm"]');
            if (submitBtn.length && submitBtn.attr('onclick')) {
                const onclickAttr = submitBtn.attr('onclick');
                const confirmMatch = onclickAttr.match(/confirm\(['"]([^'"]+)['"]\)/);
                if (confirmMatch) {
                    e.preventDefault();
                    const message = confirmMatch[1];
                    showConfirmModal(
                        message,
                        'Confirm',
                        () => {
                            submitBtn.removeAttr('onclick');
                            $(e.target).submit();
                        }
                    );
                    return false;
                }
            }
        });

        // Replace inline onclick confirm with event handlers
        $('button[onclick*="confirm"], input[onclick*="confirm"]').each(function() {
            const $this = $(this);
            const onclickAttr = $this.attr('onclick');
            if (onclickAttr && onclickAttr.includes('confirm')) {
                const confirmMatch = onclickAttr.match(/return\s+confirm\(['"]([^'"]+)['"]\)/);
                if (confirmMatch) {
                    const message = confirmMatch[1];
                    $this.removeAttr('onclick');
                    $this.on('click', function(e) {
                        if ($this.closest('form').length) {
                            e.preventDefault();
                            const form = $this.closest('form')[0];
                            showConfirmModal(
                                message,
                                'Confirm',
                                () => {
                                    form.submit();
                                }
                            );
                            return false;
                        }
                    });
                }
            }
        });
    });

    // Product search autocomplete
    $('#product-search').on('input', function() {
        const query = $(this).val();
        if (query.length >= 2) {
            $.ajax({
                url: '/api/products/search',
                data: { q: query },
                success: function(products) {
                    // Handle autocomplete results
                    console.log(products);
                }
            });
        }
    });

    // Bulk Delete - Select All functionality
    function initBulkDelete() {
        const selectAll = $('#select-all');
        const itemCheckboxes = $('.item-checkbox');
        const deleteSelectedBtn = $('#delete-selected-btn');
        const bulkDeleteForm = $('#bulk-delete-form');

        // Select All checkbox
        if (selectAll.length) {
            selectAll.on('change', function() {
                itemCheckboxes.prop('checked', $(this).prop('checked'));
                updateDeleteButton();
            });

            // Individual checkboxes
            itemCheckboxes.on('change', function() {
                const allChecked = itemCheckboxes.length === itemCheckboxes.filter(':checked').length;
                selectAll.prop('checked', allChecked);
                updateDeleteButton();
            });

            // Update delete button state
            function updateDeleteButton() {
                const checkedCount = itemCheckboxes.filter(':checked').length;
                if (checkedCount > 0) {
                    deleteSelectedBtn.prop('disabled', false);
                } else {
                    deleteSelectedBtn.prop('disabled', true);
                }
            }

            // Initialize button state
            updateDeleteButton();

            // Delete button click - show modal (Bootstrap 5)
            deleteSelectedBtn.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const checkedIds = itemCheckboxes.filter(':checked').map(function() {
                    return $(this).val();
                }).get();

                if (checkedIds.length === 0) {
                    return false;
                }

                // Show confirmation modal (Bootstrap 5)
                const modalElement = document.getElementById('bulkDeleteModal');
                if (modalElement) {
                    // Get or create modal instance
                    let modal = bootstrap.Modal.getInstance(modalElement);
                    if (!modal) {
                        modal = new bootstrap.Modal(modalElement, {
                            backdrop: true,
                            keyboard: true,
                            focus: true
                        });
                    }
                    modal.show();
                }
                return false;
            });

            // Confirm delete in modal
            $(document).off('click', '#confirm-bulk-delete').on('click', '#confirm-bulk-delete', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const checkedIds = itemCheckboxes.filter(':checked').map(function() {
                    return $(this).val();
                }).get();

                if (checkedIds.length === 0) {
                    const modalElement = document.getElementById('bulkDeleteModal');
                    if (modalElement) {
                        const modal = bootstrap.Modal.getInstance(modalElement);
                        if (modal) modal.hide();
                    }
                    return false;
                }

                // Hide modal first
                const modalElement = document.getElementById('bulkDeleteModal');
                if (modalElement) {
                    const modal = bootstrap.Modal.getInstance(modalElement);
                    if (modal) {
                        modal.hide();
                    }
                }

                // Use the existing form instead of creating a new one
                // Clear any existing hidden inputs
                bulkDeleteForm.find('input[name="selected_ids[]"]').remove();
                
                // Add selected IDs to the form
                checkedIds.forEach(function(id) {
                    const input = $('<input>').attr({
                        type: 'hidden',
                        name: 'selected_ids[]',
                        value: id
                    });
                    bulkDeleteForm.append(input);
                });

                // Submit the form after a small delay to ensure modal is closed
                setTimeout(function() {
                    bulkDeleteForm.submit();
                }, 100);
                
                return false;
            });

            // Handle modal close events to prevent page freezing
            $(document).off('hidden.bs.modal', '#bulkDeleteModal').on('hidden.bs.modal', '#bulkDeleteModal', function() {
                // Clear any pending form submissions
                bulkDeleteForm.find('input[name="selected_ids[]"]').remove();
            });
        }
    }

    // Initialize bulk delete on page load
    initBulkDelete();
});

// Accordion behavior for sidebar collapsible menus
// When one menu is opened, close all others
$(document).ready(function() {
    // Use event delegation on the sidebar to catch all collapse events
    $('.sidebar').on('show.bs.collapse', '.collapse', function(e) {
        // Get the current collapse element that's being opened
        const currentCollapse = $(this);
        
        // Get all other collapse elements in the sidebar
        $('.sidebar .collapse').not(currentCollapse).each(function() {
            // Only hide if it's currently shown
            if ($(this).hasClass('show')) {
                const bsCollapse = bootstrap.Collapse.getInstance(this);
                if (bsCollapse) {
                    bsCollapse.hide();
                }
            }
        });
    });
    
    // Mobile Sidebar Toggle
    function initMobileSidebar() {
        const sidebar = $('.sidebar');
        const sidebarToggle = $('#sidebarToggleBtn');
        const sidebarOverlay = $('.sidebar-overlay');
        
        // Create overlay if it doesn't exist
        if (sidebarOverlay.length === 0) {
            $('body').append('<div class="sidebar-overlay"></div>');
        }
        const overlay = $('.sidebar-overlay');
        
        // Toggle sidebar
        function toggleSidebar() {
            sidebar.toggleClass('show');
            overlay.toggleClass('show');
            $('body').toggleClass('sidebar-open');
        }
        
        // Sidebar toggle button
        sidebarToggle.on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleSidebar();
        });
        
        // Close sidebar when clicking overlay
        overlay.on('click', function() {
            sidebar.removeClass('show');
            overlay.removeClass('show');
            $('body').removeClass('sidebar-open');
        });
        
        // Close sidebar when clicking outside on mobile
        $(document).on('click', function(e) {
            if ($(window).width() < 992) {
                if (!$(e.target).closest('.sidebar, .sidebar-toggle').length && sidebar.hasClass('show')) {
                    sidebar.removeClass('show');
                    overlay.removeClass('show');
                    $('body').removeClass('sidebar-open');
                }
            }
        });
        
        // Close sidebar when clicking on a link (mobile only)
        if ($(window).width() < 992) {
            $('.sidebar .nav-link').on('click', function() {
                setTimeout(function() {
                    sidebar.removeClass('show');
                    overlay.removeClass('show');
                    $('body').removeClass('sidebar-open');
                }, 300);
            });
        }
        
        // Handle window resize
        $(window).on('resize', function() {
            if ($(window).width() >= 992) {
                sidebar.removeClass('show');
                overlay.removeClass('show');
                $('body').removeClass('sidebar-open');
            }
        });
    }
    
    // Initialize mobile sidebar
    initMobileSidebar();
});

