@extends('layouts.master')

@section('title', trans('messages.activity_log_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.activity_log_details') }}</h2>
    <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
    </a>
</div>

<div class="row g-3">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.information') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.user') }}:</strong> 
                            @if($activityLog->user)
                                <a href="{{ route('users.show', $activityLog->user) }}">{{ $activityLog->user->name }}</a>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </p>
                        <p><strong>{{ trans('messages.action') }}:</strong> 
                            <span class="badge bg-{{ $activityLog->action_badge }}">
                                {{ trans('messages.' . $activityLog->action) }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.description') }}:</strong> {{ $activityLog->description }}</p>
                        <p><strong>{{ trans('messages.date_time') }}:</strong> {{ $activityLog->created_at->format('Y-m-d H:i:s') }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.route') }}:</strong> {{ $activityLog->route ?? '-' }}</p>
                        <p><strong>{{ trans('messages.method') }}:</strong> {{ $activityLog->method }}</p>
                        <p><strong>{{ trans('messages.ip_address') }}:</strong> {{ $activityLog->ip_address }}</p>
                        <p><strong>{{ trans('messages.user_agent') }}:</strong> 
                            <small class="text-muted">{{ $activityLog->user_agent }}</small>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if($activityLog->model_type)
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.model_information') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ trans('messages.model_type') }}:</strong> {{ $activityLog->model_type }}</p>
                @if($activityLog->model_id)
                <p><strong>{{ trans('messages.model_id') }}:</strong> {{ $activityLog->model_id }}</p>
                @endif
                @if($activityLog->model)
                <p><strong>{{ trans('messages.model') }}:</strong> 
                    @php
                        $modelName = $activityLog->model->name ?? $activityLog->model->id ?? $activityLog->model_id;
                        $routeName = strtolower(class_basename($activityLog->model_type)) . 's.show';
                    @endphp
                    @if(Route::has($routeName))
                        <a href="{{ route($routeName, $activityLog->model) }}">{{ $modelName }}</a>
                    @else
                        {{ $modelName }}
                    @endif
                </p>
                @endif
            </div>
        </div>
    </div>
    @endif

    @if($activityLog->old_values || $activityLog->new_values)
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.old_values') }}</h5>
            </div>
            <div class="card-body">
                @if($activityLog->old_values)
                <pre class="bg-light p-3 rounded">{{ json_encode($activityLog->old_values, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                @else
                <p class="text-muted">{{ trans('messages.no_data') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.new_values') }}</h5>
            </div>
            <div class="card-body">
                @if($activityLog->new_values)
                <pre class="bg-light p-3 rounded">{{ json_encode($activityLog->new_values, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                @else
                <p class="text-muted">{{ trans('messages.no_data') }}</p>
                @endif
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

