@extends('layouts.master')

@section('title', trans('messages.sales_trends'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.sales_trends') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('analytics.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('analytics.sales-trends') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="period" class="form-label">{{ trans('messages.period') }}</label>
                    <select name="period" class="form-select">
                        <option value="daily" {{ $period == 'daily' ? 'selected' : '' }}>{{ trans('messages.daily') }}</option>
                        <option value="weekly" {{ $period == 'weekly' ? 'selected' : '' }}>{{ trans('messages.weekly') }}</option>
                        <option value="monthly" {{ $period == 'monthly' ? 'selected' : '' }}>{{ trans('messages.monthly') }}</option>
                        <option value="yearly" {{ $period == 'yearly' ? 'selected' : '' }}>{{ trans('messages.yearly') }}</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="months" class="form-label">{{ trans('messages.months') }}</label>
                    <input type="number" name="months" class="form-control" value="{{ $months }}" min="1" max="24">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
                <div class="col-md-3">
                    <div class="mt-4">
                        <span class="badge bg-{{ $trendDirection == 'up' ? 'success' : ($trendDirection == 'down' ? 'danger' : 'secondary') }}">
                            {{ trans('messages.trend_direction') }}: {{ trans('messages.trend_' . $trendDirection) }}
                        </span>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.sales_trends') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="salesTrendsChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.profit') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="profitTrendsChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
const salesTrendsCtx = document.getElementById('salesTrendsChart').getContext('2d');
const salesTrendsChart = new Chart(salesTrendsCtx, {
    type: 'line',
    data: {
        labels: @json($labels),
        datasets: [{
            label: '{{ trans('messages.total_sales') }}',
            data: @json($salesData),
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }, {
            label: '{{ trans('messages.invoice_count') }}',
            data: @json($countData),
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            tension: 0.1,
            yAxisID: 'y1'
        }]
    },
    options: {
        responsive: true,
        interaction: {
            mode: 'index',
            intersect: false,
        },
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                grid: {
                    drawOnChartArea: false,
                },
            },
        }
    }
});

const profitTrendsCtx = document.getElementById('profitTrendsChart').getContext('2d');
const profitTrendsChart = new Chart(profitTrendsCtx, {
    type: 'line',
    data: {
        labels: @json($labels),
        datasets: [{
            label: '{{ trans('messages.profit') }}',
            data: @json($profitData),
            borderColor: 'rgb(54, 162, 235)',
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            tension: 0.1,
            fill: true
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush

@push('styles')
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
@endpush
@endsection

