@php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $lang = $locale;
@endphp
<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('messages.reset_password') ?? 'Reset Password' }} - Gestock Pro</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('lib/icons/bootstrap-icons/bootstrap-icons.css') }}">
    <style>
        @php
            $fontFamily = $isRTL ? "'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif" : "'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif";
        @endphp
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        @endif
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
            opacity: 0.3;
            animation: float 20s infinite linear;
        }
        
        @keyframes float {
            0% { transform: translateY(0); }
            100% { transform: translateY(-100px); }
        }
        
        .reset-container {
            width: 100%;
            max-width: 450px;
            position: relative;
            z-index: 1;
            animation: slideUp 0.6s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .reset-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .reset-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 35px 30px;
            text-align: center;
        }
        
        .reset-header .icon-wrapper {
            width: 80px;
            height: 80px;
            background: rgba(255,255,255,0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 40px;
        }
        
        .reset-header h4 {
            font-weight: 700;
            font-size: 1.8rem;
            margin-bottom: 10px;
        }
        
        .reset-header p {
            opacity: 0.9;
            font-size: 0.95rem;
        }
        
        .reset-body {
            padding: 40px 35px;
        }
        
        .form-label {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 8px;
            font-size: 0.95rem;
        }
        
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 12px 15px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 12px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }
        
        .invalid-feedback {
            display: block;
            margin-top: 5px;
            font-size: 0.875rem;
        }
        
        .password-strength {
            margin-top: 5px;
            font-size: 0.85rem;
        }
        
        .password-strength .strength-bar {
            height: 4px;
            background: #e9ecef;
            border-radius: 2px;
            margin-top: 5px;
            overflow: hidden;
        }
        
        .password-strength .strength-fill {
            height: 100%;
            transition: all 0.3s;
            border-radius: 2px;
        }
        
        @media (max-width: 768px) {
            .reset-body {
                padding: 30px 25px;
            }
            
            .reset-header {
                padding: 25px 20px;
            }
            
            .reset-header h4 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="reset-container">
        <div class="reset-card">
            <div class="reset-header">
                <div class="icon-wrapper">
                    <i class="bi bi-shield-lock"></i>
                </div>
                <h4>{{ __('messages.reset_password') ?? 'Reset Password' }}</h4>
                <p>{{ __('messages.enter_new_password') ?? 'Enter your new password' }}</p>
            </div>
            
            <div class="reset-body">
                <form method="POST" action="{{ route('password.update') }}">
                    @csrf
                    <input type="hidden" name="token" value="{{ $request->route('token') }}">
                    
                    <div class="mb-3">
                        <label for="email" class="form-label">
                            <i class="bi bi-envelope"></i> {{ __('messages.email') ?? 'Email' }}
                        </label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $request->email) }}" required autofocus placeholder="{{ __('messages.email') ?? 'Email' }}">
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="password" class="form-label">
                            <i class="bi bi-lock"></i> {{ __('messages.password') ?? 'Password' }}
                        </label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password" required placeholder="{{ __('messages.password') ?? 'Password' }}">
                        @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">
                            <i class="bi bi-lock-fill"></i> {{ __('messages.confirm_password') ?? 'Confirm Password' }}
                        </label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required placeholder="{{ __('messages.confirm_password') ?? 'Confirm Password' }}">
                    </div>
                    
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-check-circle"></i> {{ __('messages.reset_password') ?? 'Reset Password' }}
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <script src="{{ asset('lib/js/bootstrap.bundle.min.js') }}"></script>
</body>
</html>
