@extends('layouts.master')

@section('title', trans('messages.database_backup'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.database_backup') }}</h2>
    <div>
        <form action="{{ route('backups.store') }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-success">
                <i class="bi bi-database-add"></i> {{ trans('messages.create_backup_now') }}
            </button>
        </form>
        {{-- زر تصدير SQLite مخفي مؤقتا
        <form action="{{ route('backups.export-sqlite') }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-info">
                <i class="bi bi-database"></i> {{ trans('messages.export_to_sqlite') }}
            </button>
        </form>
        --}}
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.total_backups') }}</h5>
                <h2 class="mb-0">{{ $backups->count() }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.total_size') }}</h5>
                <h2 class="mb-0">{{ format_file_size($totalSize) }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.latest_backup') }}</h5>
                <h6 class="mb-0">
                    @if($latestBackup)
                        {{ \Carbon\Carbon::createFromTimestamp($latestBackup['created_at'])->format('Y-m-d H:i:s') }}
                    @else
                        <span class="text-danger">{{ trans('messages.no_backup_created') }}</span>
                    @endif
                </h6>
            </div>
        </div>
    </div>
</div>

@if($backups->isEmpty())
<div class="alert alert-warning">
    <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.no_backups_found') }}
</div>
@else
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ trans('messages.filename') }}</th>
                        <th>{{ trans('messages.size') }}</th>
                        <th>{{ trans('messages.created_at') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($backups as $backup)
                    <tr>
                        <td>{{ $backup['filename'] }}</td>
                        <td>{{ format_file_size($backup['size']) }}</td>
                        <td>{{ \Carbon\Carbon::createFromTimestamp($backup['created_at'])->format('Y-m-d H:i:s') }}</td>
                        <td>
                            <a href="{{ route('backups.download', $backup['filename']) }}" class="btn btn-sm btn-primary">
                                <i class="bi bi-download"></i> {{ trans('messages.download') }}
                            </a>
                            <form action="{{ route('backups.restore', $backup['filename']) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_restore_backup') }}')">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-success">
                                    <i class="bi bi-arrow-clockwise"></i> {{ trans('messages.restore') }}
                                </button>
                            </form>
                            <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete('{{ $backup['filename'] }}')">
                                <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                            </button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">{{ trans('messages.confirm_delete') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>{{ trans('messages.confirm_delete_backup') }}</p>
                <p class="text-danger"><strong id="backup-filename"></strong></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                <form id="delete-form" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ trans('messages.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(filename) {
    document.getElementById('backup-filename').textContent = filename;
    document.getElementById('delete-form').action = '{{ route("backups.destroy", ":filename") }}'.replace(':filename', filename);
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}

</script>
</div>
@endsection

