@extends('layouts.master')

@section('title', trans('messages.cheque'))

@section('content')
@php
    $isRTL = app()->getLocale() === 'ar';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.cheque') }} #{{ $cheque->cheque_number }}</h2>
    <div>
        @if(!in_array($cheque->status, ['paid', 'returned']))
            <a href="{{ route('cheques.edit', $cheque) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        @endif
        <a href="{{ route('cheques.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.cheque_details') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.cheque_number') }}:</strong> {{ $cheque->cheque_number }}</p>
                        <p><strong>{{ trans('messages.type') }}:</strong> 
                            <span class="badge bg-{{ $cheque->type === 'customer' ? 'info' : 'warning' }}">
                                {{ $cheque->type === 'customer' ? trans('messages.customers') : trans('messages.suppliers') }}
                            </span>
                        </p>
                        <p><strong>{{ $cheque->type === 'customer' ? trans('messages.customer') : trans('messages.supplier') }}:</strong> 
                            @if($cheque->type === 'customer')
                                <a href="{{ route('customers.show', $cheque->customer_id) }}">{{ $cheque->customer->name ?? 'N/A' }}</a>
                            @else
                                <a href="{{ route('suppliers.edit', $cheque->supplier_id) }}">{{ $cheque->supplier->name ?? 'N/A' }}</a>
                            @endif
                        </p>
                        <p><strong>{{ trans('messages.bank_name') }}:</strong> {{ $cheque->bank_name }}</p>
                        @if($cheque->bank_account)
                        <p><strong>{{ trans('messages.bank_account') }}:</strong> {{ $cheque->bank_account }}</p>
                        @endif
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.amount') }}:</strong> <span class="badge bg-primary">{{ format_currency($cheque->amount) }}</span></p>
                        <p><strong>{{ trans('messages.issue_date') }}:</strong> {{ $cheque->issue_date->format('Y-m-d') }}</p>
                        <p><strong>{{ trans('messages.due_date') }}:</strong> 
                            <span class="{{ $cheque->due_date < now() && !$cheque->isPaid() && !$cheque->isReturned() ? 'text-danger' : '' }}">
                                {{ $cheque->due_date->format('Y-m-d') }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            @php
                                $badgeClass = match($cheque->status) {
                                    'paid' => 'success',
                                    'due' => 'warning',
                                    'returned' => 'danger',
                                    'cancelled' => 'secondary',
                                    default => 'info'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $cheque->status) }}</span>
                        </p>
                        @if($cheque->invoice)
                        <p><strong>{{ trans('messages.invoice') }}:</strong> 
                            <a href="{{ route('invoices.show', $cheque->invoice_id) }}">{{ $cheque->invoice->invoice_number }}</a>
                        </p>
                        @endif
                        @if($cheque->purchaseInvoice)
                        <p><strong>{{ trans('messages.purchase_invoice') }}:</strong> 
                            <a href="{{ route('purchase-invoices.show', $cheque->purchase_invoice_id) }}">{{ $cheque->purchaseInvoice->invoice_number }}</a>
                        </p>
                        @endif
                    </div>
                </div>
                @if($cheque->notes)
                <div class="mt-3">
                    <strong>{{ trans('messages.notes') }}:</strong>
                    <p>{{ $cheque->notes }}</p>
                </div>
                @endif
                @if($cheque->isReturned() && $cheque->return_reason)
                <div class="mt-3 alert alert-danger">
                    <strong>{{ trans('messages.return_reason') }}:</strong> {{ $cheque->return_reason }}<br>
                    <strong>{{ trans('messages.returned_date') }}:</strong> {{ $cheque->returned_date->format('Y-m-d') }}
                </div>
                @endif
                @if($cheque->isPaid() && $cheque->paid_date)
                <div class="mt-3 alert alert-success">
                    <strong>{{ trans('messages.paid_date') }}:</strong> {{ $cheque->paid_date->format('Y-m-d') }}
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.actions') }}</h5>
            </div>
            <div class="card-body">
                @if(!$cheque->isPaid() && !$cheque->isReturned() && !$cheque->isCancelled())
                    <form action="{{ route('cheques.mark-as-paid', $cheque) }}" method="POST" class="mb-2">
                        @csrf
                        <div class="mb-2">
                            <label for="paid_date" class="form-label">{{ trans('messages.paid_date') }}</label>
                            <input type="date" class="form-control" name="paid_date" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <button type="submit" class="btn btn-success w-100"><i class="bi bi-check-circle"></i> {{ trans('messages.mark_as_paid') }}</button>
                    </form>
                @endif
                @if(!$cheque->isPaid() && !$cheque->isReturned() && !$cheque->isCancelled())
                    <button type="button" class="btn btn-warning w-100 mb-2" data-bs-toggle="modal" data-bs-target="#returnChequeModal">
                        <i class="bi bi-arrow-return-left"></i> {{ trans('messages.mark_as_returned') }}
                    </button>
                @endif
                @if(!in_array($cheque->status, ['paid', 'returned']))
                    <form action="{{ route('cheques.cancel', $cheque) }}" method="POST" class="mb-2">
                        @csrf
                        <button type="submit" class="btn btn-secondary w-100" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;">
                            <i class="bi bi-x-circle"></i> {{ trans('messages.cancel') }}
                        </button>
                    </form>
                @endif
                @if(!in_array($cheque->status, ['paid', 'returned']))
                    <form action="{{ route('cheques.destroy', $cheque) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;">
                            <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                        </button>
                    </form>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Return Cheque Modal -->
<div class="modal fade" id="returnChequeModal" tabindex="-1" aria-labelledby="returnChequeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="returnChequeModalLabel">{{ trans('messages.mark_as_returned') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('cheques.mark-as-returned', $cheque) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="returned_date" class="form-label">{{ trans('messages.returned_date') }} *</label>
                        <input type="date" class="form-control" name="returned_date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="return_reason" class="form-label">{{ trans('messages.return_reason') }} *</label>
                        <textarea class="form-control" name="return_reason" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                    <button type="submit" class="btn btn-warning">{{ trans('messages.mark_as_returned') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

