@extends('layouts.master')

@section('title', trans('messages.dashboard'))

@section('content')
<div class="row mt-4">
    <div class="col-12">
        <h2 class="mb-4">{{ trans('messages.dashboard') }}</h2>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.today_sales') }}</h5>
                <h3 class="mb-0">{{ format_currency($todaySales) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.month_sales') }}</h5>
                <h3 class="mb-0">{{ format_currency($monthSales) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.pending_invoices') }}</h5>
                <h3 class="mb-0">{{ $pendingInvoices }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title">{{ trans('messages.low_stock') }}</h5>
                <h3 class="mb-0">{{ $lowStockProducts }}</h3>
            </div>
        </div>
    </div>
</div>

@if(auth()->check() && (auth()->user()->hasRole('Super Admin') || auth()->user()->hasRole('Admin')))
<div class="row g-3 mb-4">
    <div class="col-md-12">
        @php
            $treasuryBalance = \App\Http\Controllers\TreasuryController::getCurrentBalance();
        @endphp
        <div class="card {{ $treasuryBalance >= 0 ? 'border-success' : 'border-danger' }}">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-0">{{ trans('messages.current_cash_balance') }}</h5>
                        <h2 class="mb-0 {{ $treasuryBalance >= 0 ? 'text-success' : 'text-danger' }}">{{ format_currency($treasuryBalance) }}</h2>
                    </div>
                    <div>
                        <a href="{{ route('treasury.dashboard') }}" class="btn btn-primary"><i class="bi bi-cash-coin"></i> {{ trans('messages.treasury_dashboard') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Warehouse Statistics (Only if multiple warehouses mode is enabled) -->
@if(isset($warehouseStats) && $warehouseStats)
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card border-info">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="bi bi-boxes"></i> {{ trans('messages.warehouses_statistics') }}
                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h3 class="text-primary mb-0">{{ $warehouseStats['total_warehouses'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.total_warehouses') }}</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h3 class="text-success mb-0">{{ format_currency($warehouseStats['total_stock_value']) }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.total_stock_value') }}</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h3 class="text-info mb-0">{{ number_format($warehouseStats['total_products']) }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.total_products') }}</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <a href="{{ route('reports.warehouses') }}" class="btn btn-primary">
                                <i class="bi bi-graph-up"></i> {{ trans('messages.view_warehouses_report') }}
                            </a>
                        </div>
                    </div>
                </div>
                
                @if($warehouseStats['warehouses']->count() > 0)
                <hr>
                <h6 class="mb-3">{{ trans('messages.warehouses_overview') }}</h6>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.warehouse') }}</th>
                                <th class="text-end">{{ trans('messages.products_count') }}</th>
                                <th class="text-end">{{ trans('messages.stock_value') }}</th>
                                <th class="text-center">{{ trans('messages.status') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($warehouseStats['warehouses']->take(5) as $warehouse)
                            <tr class="{{ $warehouse->is_default ? 'table-primary' : '' }}">
                                <td>
                                    <a href="{{ route('warehouses.show', $warehouse) }}">
                                        {{ app()->getLocale() === 'ar' && $warehouse->name_ar ? $warehouse->name_ar : $warehouse->name }}
                                    </a>
                                    @if($warehouse->is_default)
                                        <span class="badge bg-info ms-2">{{ trans('messages.default') }}</span>
                                    @endif
                                </td>
                                <td class="text-end">{{ number_format($warehouse->total_products_count) }}</td>
                                <td class="text-end">{{ format_currency($warehouse->total_stock_value) }}</td>
                                <td class="text-center">
                                    @if($warehouse->is_active)
                                        <span class="badge bg-success">{{ trans('messages.active') }}</span>
                                    @else
                                        <span class="badge bg-secondary">{{ trans('messages.inactive') }}</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @if($warehouseStats['warehouses']->count() > 5)
                    <div class="text-center mt-2">
                        <a href="{{ route('reports.warehouses') }}" class="btn btn-sm btn-outline-primary">
                            {{ trans('messages.view_all_warehouses') }}
                        </a>
                    </div>
                @endif
                @endif
            </div>
        </div>
    </div>
</div>
@endif

<!-- Notifications Section -->
@if(isset($notifications) && $notifications->count() > 0)
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-bell"></i> {{ trans('messages.notifications') }}
                    @if(isset($unreadCount) && $unreadCount > 0)
                        <span class="badge bg-danger ms-2">{{ $unreadCount }}</span>
                    @endif
                </h5>
                <div>
                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="markAllNotificationsAsRead()">
                        <i class="bi bi-check-all"></i> {{ trans('messages.mark_all_as_read') }}
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="list-group">
                    @foreach($notifications as $notification)
                    <div class="list-group-item list-group-item-action {{ !$notification->is_read ? 'list-group-item-warning' : '' }}" 
                         data-notification-id="{{ $notification->id }}"
                         onclick="handleNotificationClick({{ $notification->id }}, '{{ $notification->url }}')"
                         style="cursor: pointer;">
                        <div class="d-flex w-100 justify-content-between align-items-start">
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center mb-1">
                                    <i class="bi {{ $notification->icon }} text-{{ $notification->severity_badge }} me-2"></i>
                                    <h6 class="mb-0 {{ !$notification->is_read ? 'fw-bold' : '' }}">
                                        {{ $notification->title }}
                                    </h6>
                                    @if(!$notification->is_read)
                                        <span class="badge bg-primary ms-2">{{ trans('messages.new') }}</span>
                                    @endif
                                </div>
                                <p class="mb-1 text-muted">{{ $notification->message }}</p>
                                <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                            </div>
                            <div class="ms-3">
                                <button type="button" class="btn btn-sm btn-outline-danger" 
                                        onclick="event.stopPropagation(); deleteNotification({{ $notification->id }})"
                                        title="{{ trans('messages.delete') }}">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@if(isset($showRecentInvoices) && $showRecentInvoices || isset($showLowStock) && $showLowStock)
<div class="row g-3 mb-4">
    @if(isset($showRecentInvoices) && $showRecentInvoices)
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.recent_invoices') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.invoice_number') }}</th>
                                <th>{{ trans('messages.customer') }}</th>
                                <th>{{ trans('messages.total') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.date') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentInvoices as $invoice)
                            <tr>
                                <td><a href="{{ route('invoices.show', $invoice) }}">{{ $invoice->invoice_number }}</a></td>
                                <td>{{ $invoice->customer?->name ?? $invoice->customer_name }}</td>
                                <td>{{ format_currency($invoice->total) }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($invoice->status) {
                                            'paid' => 'success',
                                            'partially_paid' => 'warning',
                                            'draft' => 'secondary',
                                            'returned' => 'danger',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                                </td>
                                <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">{{ trans('messages.no_invoices_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @endif
    @if(isset($showLowStock) && $showLowStock)
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.low_stock_products') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.name') }}</th>
                                <th>{{ trans('messages.stock') }}</th>
                                <th>{{ trans('messages.reorder_level') }}</th>
                                <th>{{ trans('messages.category') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($lowStockItems as $product)
                            <tr>
                                <td><a href="{{ route('products.show', $product) }}">{{ $product->name }}</a></td>
                                <td><span class="badge bg-danger">{{ $product->stock_quantity }}</span></td>
                                <td>{{ $product->reorder_level }}</td>
                                <td>{{ $product->category?->name ?? 'N/A' }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="4" class="text-center">{{ trans('messages.no_products_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endif

<!-- Quality Management Statistics -->
@if(isset($qualityStats) && $qualityStats)
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card border-info">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="bi bi-shield-check"></i> {{ trans('messages.quality_management') }}
                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-danger mb-0">{{ $qualityStats['total_defects'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.total_defects') }}</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-success mb-0">{{ $qualityStats['resolved_defects'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.resolved_defects') }}</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-warning mb-0">{{ $qualityStats['critical_defects'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.critical_defects') }}</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-danger mb-0">{{ $qualityStats['total_complaints'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.total_complaints') }}</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-success mb-0">{{ $qualityStats['resolved_complaints'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.resolved_complaints') }}</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-warning mb-0">{{ $qualityStats['critical_complaints'] }}</h3>
                            <p class="text-muted mb-0">{{ trans('messages.critical_complaints') }}</p>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="text-center">
                    @can('quality.reports.view')
                        <a href="{{ route('quality.reports.index') }}" class="btn btn-primary">
                            <i class="bi bi-file-earmark-bar-graph"></i> {{ trans('messages.quality_reports') }}
                        </a>
                    @endcan
                    @can('quality.defects.view')
                        <a href="{{ route('quality.defects.index') }}" class="btn btn-outline-danger">
                            <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.product_defects') }}
                        </a>
                    @endcan
                    @can('quality.complaints.view')
                        <a href="{{ route('quality.complaints.index') }}" class="btn btn-outline-warning">
                            <i class="bi bi-chat-left-text"></i> {{ trans('messages.quality_complaints') }}
                        </a>
                    @endcan
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@push('scripts')
<script>
function handleNotificationClick(notificationId, url) {
    // Mark as read
    fetch(`/notifications/${notificationId}/read`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).then(() => {
        // Redirect to URL if available
        if (url) {
            window.location.href = url;
        } else {
            // Reload page to update notification status
            location.reload();
        }
    });
}

function markAllNotificationsAsRead() {
    if (!confirm('{{ trans('messages.confirm_mark_all_as_read') }}')) {
        return;
    }

    fetch('/notifications/read-all', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).then(response => response.json())
      .then(data => {
          if (data.success) {
              location.reload();
          }
      });
}

function deleteNotification(notificationId) {
    if (!confirm('{{ trans('messages.confirm_delete_notification') }}')) {
        return;
    }

    fetch(`/notifications/${notificationId}`, {
        method: 'DELETE',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).then(response => response.json())
      .then(data => {
          if (data.success) {
              location.reload();
          }
      });
}

// Auto-refresh notifications every 5 minutes
setInterval(function() {
    fetch('/notifications/unread-count')
        .then(response => response.json())
        .then(data => {
            // Update badge if count changed
            const badge = document.querySelector('.badge.bg-danger');
            if (badge && parseInt(badge.textContent) !== data.count) {
                if (data.count > 0) {
                    badge.textContent = data.count;
                    badge.style.display = 'inline-block';
                } else {
                    badge.style.display = 'none';
                }
            }
        });
}, 300000); // 5 minutes
</script>
@endpush
@endsection
