<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.invoice') }} #{{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .invoice-info {
            margin: 20px 0;
        }
        .invoice-details {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .total {
            font-size: 18px;
            font-weight: bold;
            margin-top: 20px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ \App\Models\Setting::get('store_name', 'Gestock Pro') }}</h1>
        <h2>{{ trans('messages.invoice') }} #{{ $invoice->invoice_number }}</h2>
    </div>

    @if($messageText)
    <div class="message" style="background: #e7f3ff; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
        <p>{{ $messageText }}</p>
    </div>
    @endif

    <div class="invoice-info">
        <p><strong>{{ trans('messages.customer') }}:</strong> {{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
        <p><strong>{{ trans('messages.date') }}:</strong> {{ $invoice->created_at->format('Y-m-d') }}</p>
        <p><strong>{{ trans('messages.status') }}:</strong> {{ trans('messages.' . $invoice->status) }}</p>
    </div>

    <div class="invoice-details">
        <h3>{{ trans('messages.items') }}</h3>
        <table>
            <thead>
                <tr>
                    <th>{{ trans('messages.product') }}</th>
                    <th>{{ trans('messages.quantity') }}</th>
                    <th>{{ trans('messages.unit_price') }}</th>
                    <th>{{ trans('messages.total') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $item)
                <tr>
                    <td>{{ $item->product->name ?? $item->product->name_ar ?? trans('messages.unknown') }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ format_currency($item->unit_price) }}</td>
                    <td>{{ format_currency($item->total) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div style="text-align: right; margin-top: 20px;">
            <p><strong>{{ trans('messages.subtotal') }}:</strong> {{ format_currency($invoice->subtotal) }}</p>
            @if($invoice->discount > 0)
            <p><strong>{{ trans('messages.discount') }}:</strong> -{{ format_currency($invoice->discount) }}</p>
            @endif
            @if($invoice->tax > 0)
            <p><strong>{{ trans('messages.tax') }}:</strong> {{ format_currency($invoice->tax) }}</p>
            @endif
            <p class="total">{{ trans('messages.total') }}: {{ format_currency($invoice->total) }}</p>
            <p><strong>{{ trans('messages.paid') }}:</strong> {{ format_currency($invoice->paid_amount) }}</p>
            <p><strong>{{ trans('messages.due') }}:</strong> {{ format_currency($invoice->due_amount) }}</p>
        </div>
    </div>

    @if($invoice->notes)
    <div class="notes" style="margin-top: 20px;">
        <p><strong>{{ trans('messages.notes') }}:</strong></p>
        <p>{{ $invoice->notes }}</p>
    </div>
    @endif

    <div class="footer">
        <p>{{ \App\Models\Setting::get('invoice_footer_text', '') }}</p>
        <p>{{ trans('messages.thank_you') }}</p>
    </div>
</body>
</html>

