@extends('layouts.master')

@section('title', trans('messages.inventories'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.inventories') }}</h2>
    <div>
        <a href="{{ route('inventories.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> {{ trans('messages.new_inventory') }}
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('inventories.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-6">
                    <input type="text" name="search" class="form-control" 
                           placeholder="{{ trans('messages.search') }}..." 
                           value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_statuses') }}</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>
                            {{ trans('messages.draft') }}
                        </option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>
                            {{ trans('messages.completed') }}
                        </option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>
                            {{ trans('messages.cancelled') }}
                        </option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100">
                        {{ trans('messages.filter') }}
                    </button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.reference') }}</th>
                        <th>{{ trans('messages.date') }}</th>
                        <th>{{ trans('messages.status') }}</th>
                        <th>{{ trans('messages.items_count') }}</th>
                        <th>{{ trans('messages.created_by') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($inventories as $inventory)
                    <tr>
                        <td>{{ $inventory->reference }}</td>
                        <td>{{ $inventory->inventory_date ? \Carbon\Carbon::parse($inventory->inventory_date)->format('Y-m-d') : '-' }}</td>
                        <td>
                            <span class="badge bg-{{ $inventory->status == 'completed' ? 'success' : ($inventory->status == 'cancelled' ? 'danger' : 'warning') }}">
                                {{ trans('messages.' . $inventory->status) }}
                            </span>
                        </td>
                        <td>{{ $inventory->items->count() }}</td>
                        <td>{{ $inventory->user->name }}</td>
                        <td>
                            <a href="{{ route('inventories.show', $inventory) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') }}">
                                <i class="bi bi-eye"></i>
                            </a>
                            @if($inventory->status == 'draft')
                            <form action="{{ route('inventories.destroy', $inventory) }}" method="POST" class="d-inline delete-form">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete_inventory') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ trans('messages.no_inventories') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{ $inventories->links() }}
    </div>
</div>
@endsection

