@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.inventory') }} {{ $inventory->reference }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #f5f5f5;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .print-header {
            background-color: #fff;
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .print-button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            {{ $isRTL ? 'margin-right: auto;' : 'margin-left: auto;' }}
            transition: background-color 0.3s;
        }
        
        .print-button:hover {
            background-color: #0056b3;
        }
        
        .close-button {
            background-color: #6c757d;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            margin-{{ $isRTL ? 'right' : 'left' }}: 10px;
        }
        
        @media print {
            .print-header {
                display: none;
            }
            
            body {
                background-color: #fff;
                padding: 0;
            }
        }
        
        .inventory-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e0e0e0;
        }
        
        .logo {
            max-width: 150px;
            max-height: 100px;
            object-fit: contain;
        }
        
        .store-info {
            text-align: {{ $isRTL ? 'right' : 'left' }};
        }
        
        .store-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #333;
        }
        
        .inventory-title {
            font-size: 28px;
            font-weight: bold;
            color: #007bff;
            margin-bottom: 5px;
        }
        
        .inventory-reference {
            font-size: 18px;
            color: #666;
        }
        
        .info-section {
            margin-bottom: 30px;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding: 8px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .info-label {
            font-weight: bold;
            color: #555;
            width: 150px;
        }
        
        .info-value {
            color: #333;
            flex: 1;
        }
        
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .status-draft {
            background-color: #ffc107;
            color: #000;
        }
        
        .status-completed {
            background-color: #28a745;
            color: #fff;
        }
        
        .status-cancelled {
            background-color: #dc3545;
            color: #fff;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        thead {
            background-color: #f8f9fa;
        }
        
        th {
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            font-weight: bold;
            border-bottom: 2px solid #dee2e6;
            color: #495057;
        }
        
        td {
            padding: 10px 12px;
            border-bottom: 1px solid #dee2e6;
        }
        
        tbody tr:hover {
            background-color: #f8f9fa;
        }
        
        .difference-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .difference-positive {
            background-color: #28a745;
            color: #fff;
        }
        
        .difference-negative {
            background-color: #dc3545;
            color: #fff;
        }
        
        .difference-zero {
            background-color: #6c757d;
            color: #fff;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e0e0e0;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="print-header">
        <button onclick="window.print()" class="print-button">{{ trans('messages.print') }}</button>
        <button onclick="window.close()" class="close-button">{{ trans('messages.close') }}</button>
    </div>

    <div class="inventory-container">
        <div class="header">
            <div class="store-info">
                @if($storeLogo)
                    <img src="{{ storage_url($storeLogo) }}" alt="{{ $storeName }}" class="logo">
                @else
                    <div class="store-name">{{ $storeName }}</div>
                @endif
            </div>
            <div style="text-align: {{ $isRTL ? 'left' : 'right' }};">
                <div class="inventory-title">{{ trans('messages.inventory') }}</div>
                <div class="inventory-reference">{{ trans('messages.reference') }}: {{ $inventory->reference }}</div>
            </div>
        </div>

        <div class="info-section">
            <div class="info-row">
                <span class="info-label">{{ trans('messages.reference') }}:</span>
                <span class="info-value">{{ $inventory->reference }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ trans('messages.date') }}:</span>
                <span class="info-value">{{ $inventory->inventory_date ? \Carbon\Carbon::parse($inventory->inventory_date)->format('Y-m-d') : '-' }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ trans('messages.status') }}:</span>
                <span class="info-value">
                    <span class="status-badge status-{{ $inventory->status }}">
                        {{ trans('messages.' . $inventory->status) }}
                    </span>
                </span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ trans('messages.created_by') }}:</span>
                <span class="info-value">{{ $inventory->user->name }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ trans('messages.created_at') }}:</span>
                <span class="info-value">{{ $inventory->created_at->format('Y-m-d H:i') }}</span>
            </div>
            @if($inventory->notes)
            <div class="info-row">
                <span class="info-label">{{ trans('messages.notes') }}:</span>
                <span class="info-value">{{ $inventory->notes }}</span>
            </div>
            @endif
        </div>

        <table>
            <thead>
                <tr>
                    <th>{{ trans('messages.product') }}</th>
                    <th>{{ trans('messages.category') }}</th>
                    <th style="text-align: center;">{{ trans('messages.system_quantity') }}</th>
                    <th style="text-align: center;">{{ trans('messages.physical_quantity') }}</th>
                    <th style="text-align: center;">{{ trans('messages.difference') }}</th>
                    <th>{{ trans('messages.notes') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($inventory->items as $item)
                <tr>
                    <td>{{ $item->product->name }}</td>
                    <td>{{ $item->product->category?->name ?? 'N/A' }}</td>
                    <td style="text-align: center;">{{ $item->system_quantity }}</td>
                    <td style="text-align: center;">{{ $item->physical_quantity }}</td>
                    <td style="text-align: center;">
                        <span class="difference-badge difference-{{ $item->difference > 0 ? 'positive' : ($item->difference < 0 ? 'negative' : 'zero') }}">
                            {{ $item->difference > 0 ? '+' : '' }}{{ $item->difference }}
                        </span>
                    </td>
                    <td>{{ $item->notes ?? '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="footer">
            <p>{{ trans('messages.generated_at') }}: {{ now()->format('Y-m-d H:i:s') }}</p>
            <p>{{ trans('messages.inventory') }}: {{ $inventory->reference }} | {{ trans('messages.items_count') }}: {{ $inventory->items->count() }}</p>
        </div>
    </div>
</body>
</html>

