@extends('layouts.master')

@section('title', trans('messages.invoice_details'))

@section('content')
@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $isRTL = app()->getLocale() === 'ar';
    $showBarcode = \App\Models\Setting::get('invoice_show_barcode', '1') === '1';
    $showLogo = \App\Models\Setting::get('invoice_show_logo', '1') === '1';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.invoice_number') }}: {{ $invoice->invoice_number }}</h2>
    <div>
        @can('invoices.finalize')
            @if($invoice->isDraft())
                <form action="{{ route('invoices.finalize', $invoice) }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-success"><i class="bi bi-check-circle"></i> {{ trans('messages.finalize') }}</button>
                </form>
            @endif
        @endcan
        @can('invoices.update')
            @if($invoice->isDraft())
                <a href="{{ route('invoices.edit', $invoice) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
            @endif
        @endcan
        @can('invoices.return')
            @if(!$invoice->isDraft() && !$invoice->isReturned())
                <form action="{{ route('invoices.return', $invoice) }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-warning" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-box-arrow-left"></i> {{ trans('messages.return_invoice_items') }}</button>
                </form>
            @endif
        @endcan
        @can('invoices.delete')
            @if($invoice->isDraft())
                <form action="{{ route('invoices.destroy', $invoice) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete_invoice') }}')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                    </button>
                </form>
            @else
                <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteInvoiceModal">
                    <i class="bi bi-trash"></i> {{ trans('messages.delete_invoice') }}
                </button>
            @endif
        @endcan
        <a href="{{ route('invoices.print', $invoice) }}" class="btn btn-info position-relative" target="_blank" onclick="markDocumentAsExported('invoice-{{ $invoice->id }}', 'print'); showPrintNotification('{{ trans('messages.print') }}')">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
            <span id="export-badge-print-{{ $invoice->id }}" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-info" style="display: none;">
                <i class="bi bi-check-circle"></i>
            </span>
        </a>
        <a href="{{ route('invoices.devis', $invoice) }}" class="btn btn-primary position-relative" target="_blank" onclick="markDocumentAsExported('invoice-{{ $invoice->id }}', 'quotation'); showPrintNotification('{{ trans('messages.quotation') }}')">
            <i class="bi bi-file-earmark-text"></i> {{ trans('messages.print_quotation') }}
            <span id="export-badge-quotation-{{ $invoice->id }}" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-primary" style="display: none;">
                <i class="bi bi-check-circle"></i>
            </span>
        </a>
        <a href="{{ route('invoices.bon-livraison', $invoice) }}" class="btn btn-success position-relative" target="_blank" onclick="markDocumentAsExported('invoice-{{ $invoice->id }}', 'delivery_note'); showPrintNotification('{{ trans('messages.delivery_note') }}')">
            <i class="bi bi-truck"></i> {{ trans('messages.delivery_note') }}
            <span id="export-badge-delivery_note-{{ $invoice->id }}" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-success" style="display: none;">
                <i class="bi bi-check-circle"></i>
            </span>
        </a>
        @if($invoice->customer && $invoice->customer->email)
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-bell"></i> {{ trans('messages.notification_methods') }}
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#sendEmailModal">
                            <i class="bi bi-envelope"></i> {{ trans('messages.send_email') }}
                        </a>
                    </li>
                    @if($invoice->due_amount > 0)
                    <li>
                        <form action="{{ route('invoices.send-reminder', $invoice) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="dropdown-item" onclick="return confirm('{{ trans('messages.confirm_send_reminder') }}')">
                                <i class="bi bi-bell"></i> {{ trans('messages.send_reminder') }}
                            </button>
                        </form>
                    </li>
                    @endif
                </ul>
            </div>
        @endif
        <a href="{{ route('invoices.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6 invoice-logo-container">
                        @if($showLogo && $storeLogo)
                            <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}" class="invoice-logo">
                        @else
                            <h4>{{ $storeName }}</h4>
                        @endif
                    </div>
                    <div class="col-md-6 {{ $isRTL ? 'text-start' : 'text-end' }}">
                        <h4>{{ trans('messages.invoices') }}</h4>
                        <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $invoice->invoice_number }}</p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.customer') }}:</strong> {{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
                        @if($invoice->customer)
                            <p><strong>{{ trans('messages.email') }}:</strong> {{ $invoice->customer->email ?? 'N/A' }}</p>
                            <p><strong>{{ trans('messages.phone') }}:</strong> {{ $invoice->customer->phone ?? 'N/A' }}</p>
                        @endif
                    </div>
                    <div class="col-md-6 {{ $isRTL ? 'text-start' : 'text-end' }}">
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            @php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    default => 'info'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                        </p>
                        <p><strong>{{ trans('messages.date') }}:</strong> {{ $invoice->created_at->format('Y-m-d H:i') }}</p>
                        <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $invoice->user->name }}</p>
                        <div id="exported-documents-{{ $invoice->id }}" class="mt-2" style="display: none;">
                            <small class="text-muted d-block mb-1">{{ trans('messages.exported_documents') }}:</small>
                            <div id="exported-badges-{{ $invoice->id }}"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.items') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.products') }}</th>
                                @if($showBarcode)
                                <th>{{ trans('messages.barcode') }}</th>
                                @endif
                                <th>{{ trans('messages.quantity') }}</th>
                                <th>{{ trans('messages.unit_price') }}</th>
                                <th>{{ trans('messages.batch_number') }}</th>
                                <th>{{ trans('messages.supplier') }}</th>
                                <th>{{ trans('messages.tax') }}</th>
                                <th>{{ trans('messages.discount') }}</th>
                                <th>{{ trans('messages.total') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice->items as $item)
                            <tr>
                                <td>{{ $item->product->name }}</td>
                                @if($showBarcode)
                                <td>{{ $item->product->barcode ?? '-' }}</td>
                                @endif
                                <td>{{ $item->quantity }}</td>
                                <td>{{ format_currency($item->unit_price) }}</td>
                                <td>
                                    @if($item->batch)
                                        <span class="badge bg-info">{{ $item->batch->batch_number }}</span>
                                        @if($item->batch->expiry_date)
                                            <br><small class="text-muted">{{ trans('messages.expiry_date') }}: {{ $item->batch->expiry_date->format('Y-m-d') }}</small>
                                        @endif
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($item->batch && $item->batch->supplier)
                                        <a href="{{ route('suppliers.show', $item->batch->supplier) }}">{{ $item->batch->supplier->name }}</a>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>{{ $item->tax_rate }}%</td>
                                <td>{{ format_currency($item->discount) }}</td>
                                <td>{{ format_currency($item->total) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="{{ $showBarcode ? '8' : '7' }}" class="text-end"><strong>{{ trans('messages.subtotal') }}:</strong></td>
                                <td><strong>{{ format_currency($invoice->subtotal) }}</strong></td>
                            </tr>
                            @if($invoice->discount > 0)
                            <tr>
                                <td colspan="{{ $showBarcode ? '6' : '5' }}" class="text-end"><strong>{{ trans('messages.discount') }}:</strong></td>
                                <td><strong>-{{ format_currency($invoice->discount) }}</strong></td>
                            </tr>
                            @endif
                            <tr>
                                <td colspan="{{ $showBarcode ? '6' : '5' }}" class="text-end"><strong>{{ trans('messages.tax') }}:</strong></td>
                                <td><strong>{{ format_currency($invoice->tax) }}</strong></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $showBarcode ? '6' : '5' }}" class="text-end"><strong>{{ trans('messages.total') }}:</strong></td>
                                <td><strong>{{ format_currency($invoice->total) }}</strong></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $showBarcode ? '6' : '5' }}" class="text-end"><strong>{{ trans('messages.paid') }}:</strong></td>
                                <td><strong>{{ format_currency($invoice->paid_amount) }}</strong></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $showBarcode ? '6' : '5' }}" class="text-end"><strong>{{ trans('messages.due') }}:</strong></td>
                                <td><strong class="text-{{ $invoice->due_amount > 0 ? 'warning' : 'success' }}">{{ format_currency($invoice->due_amount) }}</strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        
        @if($invoice->quotation_number)
        <div class="card mb-3">
            <div class="card-body">
                <p class="mb-0">
                    <i class="bi bi-info-circle text-info"></i> 
                    <strong>{{ trans('messages.note') }}:</strong> 
                    {{ trans('messages.invoice_converted_from_quotation') }}: 
                    <strong class="text-primary">{{ $invoice->quotation_number }}</strong>
                </p>
            </div>
        </div>
        @endif
    </div>
    <div class="col-md-4">
        @if(!$invoice->isDraft() && $invoice->due_amount > 0)
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.record_payment') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('payments.store', $invoice) }}">
                    @csrf
                    <div class="mb-3">
                        <label for="amount" class="form-label">{{ trans('messages.amount') }} *</label>
                        <div class="input-group">
                            <input type="number" step="0.01" class="form-control" id="amount" name="amount" max="{{ $invoice->due_amount }}" required>
                            <button type="button" class="btn btn-outline-secondary" id="fillTotalAmount" title="{{ trans('messages.fill_total_amount') }}">
                                <i class="bi bi-arrow-down-circle"></i> {{ trans('messages.total') }}
                            </button>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">{{ trans('messages.payment_method') }} *</label>
                        <select class="form-select" id="payment_method" name="payment_method" required>
                            <option value="cash">{{ trans('messages.cash') }}</option>
                            <option value="bank_transfer">{{ trans('messages.bank_transfer') }}</option>
                            <option value="credit">{{ trans('messages.credit') }}</option>
                            <option value="cheque">{{ trans('messages.cheque') }}</option>
                            <option value="promissory_note">{{ trans('messages.promissory_note') }}</option>
                            <option value="online">{{ trans('messages.online') }}</option>
                            <option value="other">{{ trans('messages.other') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">{{ trans('messages.date') }}</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}">
                    </div>
                    <button type="submit" class="btn btn-primary w-100">{{ trans('messages.record_payment') }}</button>
                </form>
            </div>
        </div>
        @endif

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.payment_history') }}</h5>
            </div>
            <div class="card-body">
                @if($invoice->payments->count() > 0)
                    <div class="list-group">
                        @foreach($invoice->payments as $payment)
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between">
                                <div style="flex: 1;">
                                    <strong>{{ format_currency($payment->amount) }}</strong><br>
                                    <small class="text-muted">{{ trans('messages.' . $payment->payment_method) }} - {{ $payment->created_at->format('Y-m-d H:i') }}</small>
                                    @if($payment->payment_method === 'cheque' && $invoice->customer_id)
                                        <br>
                                        <a href="{{ route('cheques.create', ['type' => 'customer', 'customer_id' => $invoice->customer_id, 'invoice_id' => $invoice->id, 'amount' => $payment->amount]) }}" 
                                           class="btn btn-sm btn-outline-primary mt-2">
                                            <i class="bi bi-bank"></i> {{ trans('messages.add_cheque') }}
                                        </a>
                                    @elseif($payment->payment_method === 'promissory_note' && $invoice->customer_id)
                                        <br>
                                        <a href="{{ route('promissory-notes.create', ['type' => 'customer', 'customer_id' => $invoice->customer_id, 'invoice_id' => $invoice->id, 'amount' => $payment->amount]) }}" 
                                           class="btn btn-sm btn-outline-primary mt-2">
                                            <i class="bi bi-file-text"></i> {{ trans('messages.add_promissory_note') }}
                                        </a>
                                    @endif
                                </div>
                                <form action="{{ route('payments.destroy', $payment) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-muted">{{ trans('messages.no_payments') }}</p>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Invoice Confirmation Modal -->
@if(auth()->user()->hasAnyRole(['Admin', 'Super Admin']))
<div class="modal fade" id="deleteInvoiceModal" tabindex="-1" aria-labelledby="deleteInvoiceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteInvoiceModalLabel">{{ trans('messages.confirm_delete') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>{{ trans('messages.confirm_delete_invoice') }}</p>
                <p class="text-muted"><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $invoice->invoice_number }}</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                <form action="{{ route('invoices.destroy', $invoice) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ trans('messages.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const fillTotalBtn = document.getElementById('fillTotalAmount');
        const amountInput = document.getElementById('amount');
        const totalAmount = {{ $invoice->total }};
        const maxAmount = {{ $invoice->due_amount }};
        
        if (fillTotalBtn && amountInput) {
            fillTotalBtn.addEventListener('click', function() {
                // Fill with total amount, but not more than due amount
                const fillAmount = Math.min(totalAmount, maxAmount);
                amountInput.value = fillAmount.toFixed(2);
                // Trigger input event to ensure validation
                amountInput.dispatchEvent(new Event('input'));
            });
        }
    });

    // Track exported documents
    const invoiceId = {{ $invoice->id }};
    
    // Initialize exported documents display
    document.addEventListener('DOMContentLoaded', function() {
        checkExportedDocuments();
    });

    function checkExportedDocuments() {
        const exportedDocs = JSON.parse(localStorage.getItem('exported_documents_' + invoiceId) || '{}');
        const exportedDiv = document.getElementById('exported-documents-' + invoiceId);
        const badgesDiv = document.getElementById('exported-badges-' + invoiceId);
        
        if (Object.keys(exportedDocs).length > 0) {
            exportedDiv.style.display = 'block';
            badgesDiv.innerHTML = '';
            
            const documentTypes = {
                'print': '{{ trans("messages.print") }}',
                'quotation': '{{ trans("messages.quotation") }}',
                'delivery_note': '{{ trans("messages.delivery_note") }}'
            };
            
            const documentColors = {
                'print': 'info',
                'quotation': 'primary',
                'delivery_note': 'success'
            };
            
            Object.keys(exportedDocs).forEach(function(docType) {
                if (exportedDocs[docType]) {
                    const badge = document.createElement('span');
                    const color = documentColors[docType] || 'success';
                    badge.className = 'badge bg-' + color + ' me-1 mb-1';
                    badge.innerHTML = '<i class="bi bi-check-circle"></i> ' + (documentTypes[docType] || docType);
                    badgesDiv.appendChild(badge);
                    
                    // Show badge on button
                    const buttonBadge = document.getElementById('export-badge-' + docType + '-' + invoiceId);
                    if (buttonBadge) {
                        buttonBadge.style.display = 'inline-block';
                    }
                }
            });
        }
    }

    function markDocumentAsExported(invoiceKey, documentType) {
        const exportedDocs = JSON.parse(localStorage.getItem('exported_documents_' + invoiceId) || '{}');
        exportedDocs[documentType] = true;
        localStorage.setItem('exported_documents_' + invoiceId, JSON.stringify(exportedDocs));
        
        // Update display
        setTimeout(function() {
            checkExportedDocuments();
        }, 100);
    }

    // Toast notification for print actions
    function showPrintNotification(documentType) {
        const message = '{{ trans("messages.document_printed_successfully") }}'.replace(':document', documentType);
        showToastNotification(message, 'success');
    }

    function showToastNotification(message, type = 'success') {
        // Create toast container if it doesn't exist
        let toastContainer = document.getElementById('toast-container');
        if (!toastContainer) {
            toastContainer = document.createElement('div');
            toastContainer.id = 'toast-container';
            toastContainer.className = 'toast-container position-fixed {{ $isRTL ? "start-0" : "end-0" }} p-3';
            toastContainer.style.cssText = 'top: 80px; z-index: 9999;';
            document.body.appendChild(toastContainer);
        }

        // Create toast element
        const toastId = 'toast-' + Date.now();
        const toast = document.createElement('div');
        toast.id = toastId;
        toast.className = 'toast align-items-center text-white bg-' + (type === 'success' ? 'success' : 'danger') + ' border-0';
        toast.setAttribute('role', 'alert');
        toast.setAttribute('aria-live', 'assertive');
        toast.setAttribute('aria-atomic', 'true');
        
        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">
                    <i class="bi bi-${type === 'success' ? 'check-circle' : 'exclamation-triangle'}-fill me-2"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        `;
        
        toastContainer.appendChild(toast);
        
        // Initialize and show toast
        const bsToast = new bootstrap.Toast(toast, {
            autohide: true,
            delay: 4000
        });
        
        bsToast.show();
        
        // Remove toast element after it's hidden
        toast.addEventListener('hidden.bs.toast', function() {
            toast.remove();
        });
    }

</script>
@endpush

<!-- Send Email Modal -->
@if($invoice->customer && $invoice->customer->email)
<div class="modal fade" id="sendEmailModal" tabindex="-1" aria-labelledby="sendEmailModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sendEmailModalLabel">{{ trans('messages.send_invoice_email') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
                <form action="{{ route('invoices.send-email', $invoice) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="email" class="form-label">{{ trans('messages.email') }} <span class="text-danger">*</span></label>
                        <input type="email" class="form-control" id="email" name="email" value="{{ $invoice->customer->email }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="message" class="form-label">{{ trans('messages.message') }} ({{ trans('messages.optional') }})</label>
                        <textarea class="form-control" id="message" name="message" rows="4" placeholder="{{ trans('messages.email_message_placeholder') }}"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-send"></i> {{ trans('messages.send') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
@endsection
