@php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $lang = $locale;
@endphp
<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $isRTL ? 'تفعيل الترخيص' : 'License Activation' }} - Gestock Pro</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('lib/icons/bootstrap-icons/bootstrap-icons.css') }}">
    <style>
        @php
            $fontFamily = $isRTL ? "'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif" : "'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif";
        @endphp
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        @endif
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
            opacity: 0.3;
            animation: float 20s infinite linear;
        }
        
        @keyframes float {
            0% { transform: translateY(0); }
            100% { transform: translateY(-100px); }
        }
        
        .license-container {
            width: 100%;
            max-width: 600px;
            position: relative;
            z-index: 1;
            animation: slideUp 0.6s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .license-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .license-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            text-align: center;
        }
        
        .license-header .icon-wrapper {
            width: 55px;
            height: 55px;
            background: rgba(255,255,255,0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 8px;
            font-size: 28px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }
        
        .license-header h2 {
            font-weight: 700;
            font-size: 1.25rem;
            margin-bottom: 3px;
        }
        
        .license-header p {
            opacity: 0.9;
            font-size: 0.75rem;
            margin-bottom: 0;
        }
        
        .license-body {
            padding: 18px 30px;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            padding: 10px;
            margin-bottom: 12px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.08);
        }
        
        .alert-success {
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
            color: #155724;
            border-left: 4px solid #28a745;
        }
        
        .alert-warning {
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
            color: #856404;
            border-left: 4px solid #ffc107;
        }
        
        .alert-danger {
            background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
            color: #721c24;
            border-left: 4px solid #dc3545;
        }
        
        .alert h5 {
            font-weight: 600;
            margin-bottom: 5px;
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 0.9rem;
        }
        
        .form-label {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 4px;
            font-size: 0.85rem;
        }
        
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 7px 15px;
            font-size: 0.9rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .form-text {
            font-size: 0.85rem;
            margin-top: 3px;
        }
        
        .btn {
            font-weight: 600;
            border-radius: 10px;
            padding: 10px 25px;
            transition: all 0.3s;
            border: none;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-info {
            background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
            color: white;
        }
        
        .btn-info:hover {
            transform: translateY(-2px);
        }
        
        .btn-sm {
            padding: 8px 20px;
            font-size: 0.9rem;
        }
        
        .btn-lg {
            padding: 10px 25px;
            font-size: 0.95rem;
        }
        
        .invalid-feedback {
            display: block;
            margin-top: 3px;
            font-size: 0.875rem;
            color: #dc3545;
        }
        
        .mb-3 {
            margin-bottom: 0.75rem !important;
        }
        
        .row {
            margin-bottom: 0.5rem;
        }
        
        .row .mb-3 {
            margin-bottom: 0.75rem !important;
        }
        
        hr {
            margin: 15px 0;
            border: none;
            border-top: 2px solid #e9ecef;
        }
        
        .text-muted a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .text-muted a:hover {
            color: #764ba2;
            text-decoration: underline;
        }
        
        @media (max-width: 768px) {
            .license-body {
                padding: 30px 25px;
            }
            
            .license-header {
                padding: 25px 20px;
            }
            
            .license-header h2 {
                font-size: 1.5rem;
            }
            
            .license-header .icon-wrapper {
                width: 80px;
                height: 80px;
                font-size: 40px;
            }
        }
    </style>
</head>
<body>
    <div class="license-container">
        <div class="license-card">
            <div class="license-header">
                <div class="icon-wrapper">
                    <i class="bi bi-key"></i>
                </div>
                <h2>{{ $isRTL ? 'تفعيل الترخيص' : 'License Activation' }}</h2>
                <p>{{ $isRTL ? 'أدخل معلومات الترخيص للاستمرار' : 'Enter license information to continue' }}</p>
            </div>
            
            <div class="license-body">
                @if(session('error'))
                    <div class="alert alert-danger">
                        <h5>
                            <i class="bi bi-exclamation-triangle"></i> 
                            {{ $isRTL ? 'خطأ' : 'Error' }}
                        </h5>
                        <p class="mb-0">{{ session('error') }}</p>
                    </div>
                @endif

                @if($licenseInfo && $licenseInfo['is_valid'])
                    <div class="alert alert-success">
                        <h5>
                            <i class="bi bi-check-circle"></i> 
                            {{ $isRTL ? 'الترخيص مفعّل' : 'License Activated' }}
                        </h5>
                        <p class="mb-2">
                            <strong>{{ $isRTL ? 'الترخيص نشط حتى:' : 'License active until:' }}</strong> 
                            {{ $licenseInfo['expires_at'] ?? ($isRTL ? 'دائم' : 'Permanent') }}
                        </p>
                        @if($licenseInfo['days_remaining'] !== null)
                            <p class="mb-3">
                                <strong>{{ $isRTL ? 'الأيام المتبقية:' : 'Days remaining:' }}</strong> 
                                <span class="badge bg-success">{{ $licenseInfo['days_remaining'] }} {{ $isRTL ? 'يوم' : 'days' }}</span>
                            </p>
                        @endif
                        <div class="d-flex gap-2 flex-wrap">
                            <a href="{{ route('license.info') }}" class="btn btn-info btn-sm">
                                <i class="bi bi-info-circle"></i> 
                                {{ $isRTL ? 'عرض التفاصيل' : 'View Details' }}
                            </a>
                            <a href="{{ route('dashboard') }}" class="btn btn-primary btn-sm">
                                <i class="bi bi-house"></i> 
                                {{ $isRTL ? 'العودة للوحة التحكم' : 'Back to Dashboard' }}
                            </a>
                        </div>
                    </div>
                @else
                    <div class="alert alert-warning">
                        <h5>
                            <i class="bi bi-exclamation-triangle"></i> 
                            {{ $isRTL ? 'انتهت الفترة التجريبية' : 'Trial Period Expired' }}
                        </h5>
                        <p class="mb-0">
                            {{ $isRTL ? 'للاستمرار في استخدام التطبيق، يرجى إدخال مفتاح الترخيص.' : 'To continue using the application, please enter your license key.' }}
                        </p>
                    </div>

                    <form method="POST" action="{{ route('license.activate') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="license_key" class="form-label">
                                <i class="bi bi-key"></i> 
                                {{ $isRTL ? 'مفتاح الترخيص (License Key)' : 'License Key' }}
                            </label>
                            <input type="text" 
                                   class="form-control @error('license_key') is-invalid @enderror" 
                                   id="license_key" 
                                   name="license_key" 
                                   value="{{ old('license_key') }}"
                                   placeholder="{{ $isRTL ? 'XXXX-XXXX-XXXX-XXXX' : 'XXXX-XXXX-XXXX-XXXX' }}"
                                   required>
                            @error('license_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                {{ $isRTL ? 'تنسيق: XXXX-XXXX-XXXX-XXXX' : 'Format: XXXX-XXXX-XXXX-XXXX' }}
                            </small>
                        </div>

                        <div class="mb-3">
                            <label for="serial_number" class="form-label">
                                <i class="bi bi-hash"></i> 
                                {{ $isRTL ? 'الرقم التسلسلي (Serial Number)' : 'Serial Number' }}
                            </label>
                            <input type="text" 
                                   class="form-control @error('serial_number') is-invalid @enderror" 
                                   id="serial_number" 
                                   name="serial_number" 
                                   value="{{ old('serial_number') }}"
                                   placeholder="{{ $isRTL ? 'SN-XXXXXXXXXXXX' : 'SN-XXXXXXXXXXXX' }}"
                                   required>
                            @error('serial_number')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                {{ $isRTL ? 'تنسيق: SN-XXXXXXXXXXXX' : 'Format: SN-XXXXXXXXXXXX' }}
                            </small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">
                                    <i class="bi bi-person"></i> 
                                    {{ $isRTL ? 'الاسم (اختياري)' : 'Name (Optional)' }}
                                </label>
                                <input type="text" 
                                       class="form-control" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}"
                                       placeholder="{{ $isRTL ? 'الاسم' : 'Name' }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">
                                    <i class="bi bi-envelope"></i> 
                                    {{ $isRTL ? 'البريد الإلكتروني (اختياري)' : 'Email (Optional)' }}
                                </label>
                                <input type="email" 
                                       class="form-control" 
                                       id="email" 
                                       name="email" 
                                       value="{{ old('email') }}"
                                       placeholder="{{ $isRTL ? 'example@email.com' : 'example@email.com' }}">
                            </div>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle"></i> 
                                {{ $isRTL ? 'تفعيل الترخيص' : 'Activate License' }}
                            </button>
                        </div>

                        <hr>

                        <div class="text-center">
                            <p class="text-muted mb-0">
                                <small>
                                    {{ $isRTL ? 'لا تملك مفتاح ترخيص؟' : "Don't have a license key?" }} 
                                    <a href="mailto:imranesoft@gmail.com">imranesoft@gmail.com</a>
                                </small>
                            </p>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>
    
    <script src="{{ asset('lib/js/bootstrap.bundle.min.js') }}"></script>
</body>
</html>
