@extends('layouts.master')

@section('title', 'معلومات الترخيص')

@section('content')
<div class="row">
    <div class="col-md-8 offset-md-2">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h4><i class="bi bi-info-circle"></i> معلومات الترخيص</h4>
            </div>
            <div class="card-body">
                @if($licenseInfo)
                    <table class="table table-bordered">
                        <tr>
                            <th width="200">مفتاح الترخيص</th>
                            <td>{{ $licenseInfo['license_key'] }}</td>
                        </tr>
                        <tr>
                            <th>الرقم التسلسلي</th>
                            <td>{{ $licenseInfo['serial_number'] }}</td>
                        </tr>
                        <tr>
                            <th>اسم العميل</th>
                            <td>{{ $licenseInfo['customer_name'] ?? 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>البريد الإلكتروني</th>
                            <td>{{ $licenseInfo['email'] ?? 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>تاريخ التفعيل</th>
                            <td>{{ $licenseInfo['activated_at'] }}</td>
                        </tr>
                        <tr>
                            <th>تاريخ الانتهاء</th>
                            <td>
                                {{ $licenseInfo['expires_at'] ?? 'دائم' }}
                                @if($licenseInfo['days_remaining'] !== null)
                                    <span class="badge bg-{{ $licenseInfo['days_remaining'] > 30 ? 'success' : 'warning' }}">
                                        {{ $licenseInfo['days_remaining'] }} يوم متبقي
                                    </span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>الحالة</th>
                            <td>
                                <span class="badge bg-{{ $licenseInfo['is_valid'] ? 'success' : 'danger' }}">
                                    {{ $licenseInfo['is_valid'] ? 'نشط' : 'غير نشط' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>عدد المستخدمين المسموح</th>
                            <td>{{ $licenseInfo['max_users'] }}</td>
                        </tr>
                    </table>
                @else
                    <div class="alert alert-warning">
                        لا يوجد ترخيص مفعّل حالياً.
                    </div>
                @endif

                <div class="mt-3">
                    <a href="{{ route('license.activate') }}" class="btn btn-primary">
                        <i class="bi bi-key"></i> تفعيل ترخيص جديد
                    </a>
                    <a href="{{ route('dashboard') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left"></i> العودة
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

