@extends('layouts.master')

@section('title', trans('messages.manage_permissions') . ' - ' . $user->name)

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.manage_permissions') }} - {{ $user->name }}</h2>
    <a href="{{ route('permissions.index') }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
    </a>
</div>

<div class="row g-3">
    <!-- User Info -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.user_information') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.name') }}:</strong> {{ $user->name }}</p>
                        <p><strong>{{ trans('messages.email') }}:</strong> {{ $user->email }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            <span class="badge bg-{{ $user->status == 'active' ? 'success' : 'danger' }}">
                                {{ trans('messages.' . $user->status) }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.current_roles') }}:</strong>
                            @foreach($user->roles as $role)
                                <span class="badge bg-primary">{{ $role->name }}</span>
                            @endforeach
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Roles Management -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.manage_roles') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('permissions.user.roles', $user) }}">
                    @csrf
                    <div class="mb-3">
                        @forelse($allRoles as $role)
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="checkbox" name="roles[]" 
                                   value="{{ $role->id }}" 
                                   id="role_{{ $role->id }}"
                                   {{ $user->hasRole($role) ? 'checked' : '' }}>
                            <label class="form-check-label" for="role_{{ $role->id }}">
                                {{ $role->name }}
                                <small class="text-muted">({{ $role->permissions->count() }} {{ trans('messages.permissions') }})</small>
                            </label>
                        </div>
                        @empty
                        <p class="text-muted">{{ trans('messages.no_roles_found') }}</p>
                        @endforelse
                    </div>
                    @if($allRoles->count() > 0)
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-save"></i> {{ trans('messages.update_roles') }}
                    </button>
                    @endif
                </form>
            </div>
        </div>
    </div>

    <!-- Custom Permissions -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.custom_permissions') }}</h5>
                <small class="text-muted">{{ trans('messages.permissions_note') }}</small>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('permissions.user.permissions', $user) }}">
                    @csrf
                    @if($allPermissions->count() > 0)
                    <div class="accordion" id="permissionsAccordion">
                        @foreach($allPermissions as $group => $groupPermissions)
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $loop->index }}">
                                    {{ ucfirst($group) }} ({{ count($groupPermissions) }})
                                </button>
                            </h2>
                            <div id="collapse{{ $loop->index }}" class="accordion-collapse collapse" data-bs-parent="#permissionsAccordion">
                                <div class="accordion-body">
                                    @foreach($groupPermissions as $permission)
                                    @php
                                        $hasPermission = $user->hasPermissionTo($permission);
                                        $hasDirectPermission = $user->hasDirectPermission($permission);
                                        $hasPermissionFromRole = $hasPermission && !$hasDirectPermission;
                                    @endphp
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" name="permissions[]" 
                                               value="{{ $permission->id }}" 
                                               id="perm_{{ $permission->id }}"
                                               {{ $hasPermission ? 'checked' : '' }}
                                               {{ $hasPermissionFromRole ? 'disabled' : '' }}
                                               title="{{ $hasDirectPermission ? trans('messages.direct_permission') : ($hasPermissionFromRole ? trans('messages.permission_from_role') : '') }}">
                                        <label class="form-check-label {{ $hasPermissionFromRole ? 'text-muted' : '' }}" for="perm_{{ $permission->id }}">
                                            {{ $permission->name }}
                                            @if($hasDirectPermission)
                                                <span class="badge bg-success ms-2">{{ trans('messages.direct') }}</span>
                                            @elseif($hasPermissionFromRole)
                                                <span class="badge bg-info ms-2">{{ trans('messages.from_role') }}</span>
                                            @endif
                                        </label>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="alert alert-info mt-3">
                        <small>
                            <i class="bi bi-info-circle"></i> 
                            {{ trans('messages.permissions_info') }}
                        </small>
                    </div>
                    <button type="submit" class="btn btn-primary w-100 mt-3">
                        <i class="bi bi-save"></i> {{ trans('messages.update_permissions') }}
                    </button>
                    @else
                    <p class="text-muted">{{ trans('messages.no_permissions_found') }}</p>
                    @endif
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Ensure disabled checkboxes (permissions from roles) are not submitted
    $('form').on('submit', function(e) {
        // Remove disabled checkboxes from form submission
        $(this).find('input[type="checkbox"]:disabled').each(function() {
            $(this).prop('disabled', false);
            $(this).prop('checked', false);
            $(this).prop('disabled', true);
        });
    });
});
</script>
@endpush
@endsection

