@forelse($products as $product)
@php
    $stockQuantity = \App\Services\StockManager::getStockQuantity($product, $warehouseId);
@endphp
<div class="col-md-4 col-sm-6">
    <div class="card h-100 product-card {{ $stockQuantity <= 0 ? 'opacity-75' : '' }}">
        @if(isset($posSettings['show_images']) && $posSettings['show_images'])
            @if($product->image)
            <img src="{{ storage_url($product->image) }}" class="card-img-top" alt="{{ $product->name }}" style="height: 150px; object-fit: cover;">
            @else
            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 150px;">
                <i class="bi bi-basket" style="font-size: 3rem; color: #ccc;"></i>
            </div>
            @endif
        @endif
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <h6 class="card-title mb-0">{{ $isRTL && $product->name_ar ? $product->name_ar : $product->name }}</h6>
                <button class="btn btn-sm toggle-favorite-btn btn-outline-warning" 
                        data-product-id="{{ $product->id }}"
                        title="{{ trans('messages.add_to_favorites') }}">
                    <i class="bi bi-star"></i>
                </button>
            </div>
            <p class="card-text mb-2">
                <strong>{{ format_currency($product->selling_price) }}</strong>
                @if(isset($posSettings['show_stock']) && $posSettings['show_stock'])
                <small class="text-muted d-block">
                    {{ trans('messages.stock') }}: {{ $stockQuantity }}
                    @if($stockQuantity <= 0)
                        <span class="badge bg-danger ms-2">{{ trans('messages.out_of_stock') }}</span>
                    @elseif($product->isLowStock($warehouseId))
                        <span class="badge bg-warning ms-2">{{ trans('messages.low_stock') }}</span>
                    @endif
                </small>
                @endif
            </p>
            <div class="input-group mb-2">
                <input type="number" class="form-control product-quantity" 
                       data-product-id="{{ $product->id }}" 
                       value="1" min="1" 
                       @if(!$allowNegativeStock)
                           max="{{ max(1, $stockQuantity) }}"
                       @endif
                       @if(!$allowNegativeStock && $stockQuantity <= 0)
                           disabled
                       @endif>
                <button class="btn btn-primary add-to-cart-btn {{ (!$allowNegativeStock && $stockQuantity <= 0) ? 'disabled' : '' }}" 
                        data-product-id="{{ $product->id }}"
                        data-product-name="{{ $isRTL && $product->name_ar ? $product->name_ar : $product->name }}"
                        @if(!$allowNegativeStock && $stockQuantity <= 0)
                            disabled
                        @endif>
                    <i class="bi bi-cart-plus"></i> {{ trans('messages.add_to_cart') }}
                </button>
            </div>
        </div>
    </div>
</div>
@empty
<div class="col-12">
    <div class="alert alert-info text-center">
        <i class="bi bi-info-circle"></i> {{ trans('messages.no_products_found') }}
    </div>
</div>
@endforelse

