@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.low_stock_products') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #f5f5f5;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .print-header {
            background-color: #fff;
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .print-button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            {{ $isRTL ? 'margin-right: auto;' : 'margin-left: auto;' }}
            transition: background-color 0.3s;
        }
        
        .print-button:hover {
            background-color: #0056b3;
        }
        
        .print-button:active {
            background-color: #004085;
        }
        
        @media print {
            .print-header {
                display: none;
            }
            
            body {
                background-color: #fff;
                padding: 0;
            }
        }
        
        .report-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            color: #666;
            line-height: 1.6;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            vertical-align: middle;
        }
        
        th {
            background-color: #f2f2f2;
            font-weight: bold;
            color: #333;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tbody tr:hover {
            background-color: #f5f5f5;
        }
        
        .product-image {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 4px;
        }
        
        .product-image-placeholder {
            width: 50px;
            height: 50px;
            background-color: #e9ecef;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
            color: #999;
            font-size: 20px;
        }
        
        .low-stock-badge {
            background-color: #dc3545;
            color: white;
            padding: 4px 10px;
            border-radius: 3px;
            font-size: 11px;
            font-weight: bold;
            display: inline-block;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-{{ $isRTL ? 'start' : 'end' }} {
            text-align: {{ $isRTL ? 'left' : 'right' }};
        }
        
        .summary {
            margin-top: 30px;
            padding: 20px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        
        .summary h3 {
            margin-bottom: 15px;
            font-size: 18px;
            color: #333;
        }
        
        .summary p {
            margin: 8px 0;
            color: #666;
            line-height: 1.6;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
            font-size: 12px;
            color: #666;
        }
        
        .product-name {
            font-weight: bold;
            color: #333;
        }
        
        .category-name {
            color: #666;
            font-size: 12px;
        }
        
        .no-products {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
        
        .no-products p {
            font-size: 18px;
        }
    </style>
</head>
<body>
    <div class="print-header">
        <h3>{{ trans('messages.low_stock_products') }}</h3>
        <div>
            <button class="print-button" onclick="window.print()">
                <i class="bi bi-printer"></i> {{ trans('messages.print') }}
            </button>
            <button class="print-button" onclick="window.close()" style="background-color: #6c757d; margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
                <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
            </button>
        </div>
    </div>
    
    <div class="report-container">
        <div class="header">
            <div class="logo-container">
                @if($storeLogo)
                    <img src="{{ storage_url($storeLogo) }}" alt="{{ $storeName }}">
                @else
                    <h2>{{ $storeName }}</h2>
                @endif
            </div>
            <div class="report-info">
                <h2>{{ trans('messages.low_stock_products') }}</h2>
                <p><strong>{{ trans('messages.date') }}:</strong> {{ date('Y-m-d') }}</p>
                <p><strong>{{ trans('messages.total_products') }}:</strong> {{ $products->count() }}</p>
            </div>
        </div>

        @if($products->count() > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 60px;">{{ trans('messages.image') }}</th>
                    <th>{{ trans('messages.product_name') }}</th>
                    <th>{{ trans('messages.sku') }}</th>
                    <th>{{ trans('messages.barcode') }}</th>
                    <th>{{ trans('messages.category') }}</th>
                    <th class="text-center">{{ trans('messages.stock_quantity') }}</th>
                    <th class="text-{{ $isRTL ? 'start' : 'end' }}">{{ trans('messages.selling_price') }}</th>
                    <th class="text-{{ $isRTL ? 'start' : 'end' }}">{{ trans('messages.purchase_price') }}</th>
                    <th class="text-center">{{ trans('messages.status') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $product)
                <tr>
                    <td class="text-center">
                        @if($product->image && \Storage::disk('public')->exists($product->image))
                            <img src="{{ storage_url($product->image) }}" class="product-image" alt="{{ $product->name }}">
                        @else
                            <div class="product-image-placeholder">📦</div>
                        @endif
                    </td>
                    <td>
                        <div class="product-name">{{ app()->getLocale() === 'ar' && $product->name_ar ? $product->name_ar : $product->name }}</div>
                    </td>
                    <td><strong>{{ $product->sku ?? '-' }}</strong></td>
                    <td>{{ $product->barcode ?? '-' }}</td>
                    <td>{{ $product->category ? (app()->getLocale() === 'ar' && $product->category->name_ar ? $product->category->name_ar : $product->category->name) : '-' }}</td>
                    <td class="text-center"><strong>{{ $product->stock_quantity }}</strong></td>
                    <td class="text-{{ $isRTL ? 'start' : 'end' }}">{{ number_format($product->selling_price, 2) }} {{ $currency }}</td>
                    <td class="text-{{ $isRTL ? 'start' : 'end' }}">{{ number_format($product->purchase_price, 2) }} {{ $currency }}</td>
                    <td class="text-center">
                        <span class="low-stock-badge">{{ trans('messages.low_stock') }}</span>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="summary">
            <h3>{{ trans('messages.summary') }}</h3>
            <p><strong>{{ trans('messages.total_low_stock_products') }}:</strong> {{ $products->count() }}</p>
            <p><strong>{{ trans('messages.total_stock_value') }}:</strong> {{ number_format($products->sum(function($p) { return $p->stock_quantity * $p->purchase_price; }), 2) }} {{ $currency }}</p>
        </div>
        @else
        <div class="no-products">
            <p>{{ trans('messages.no_low_stock_products') }}</p>
        </div>
        @endif

        <div class="footer">
            <p>{{ trans('messages.generated_at') }}: {{ now()->format('Y-m-d H:i:s') }}</p>
        </div>
    </div>
</body>
</html>

