@extends('layouts.master')

@section('title', trans('messages.product_reports'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.product_reports') }}</h2>
    <div>
        <a href="{{ route('products.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back_to_products') }}
        </a>
    </div>
</div>

<div class="row g-3 mb-4">
    <!-- Summary Cards -->
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h6 class="card-title">{{ trans('messages.total_products') }}</h6>
                <h3 class="mb-0">{{ number_format($summary['total_products']) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h6 class="card-title">{{ trans('messages.sold_products') }}</h6>
                <h3 class="mb-0">{{ number_format($summary['sold_products']) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h6 class="card-title">{{ trans('messages.unsold_products') }}</h6>
                <h3 class="mb-0">{{ number_format($summary['unsold_products']) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h6 class="card-title">{{ trans('messages.total_profit') }}</h6>
                <h3 class="mb-0">{{ format_currency($summary['total_profit']) }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('products.reports') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="type" class="form-label">{{ trans('messages.report_type') }}</label>
                    <select name="type" id="type" class="form-select">
                        <option value="best_selling" {{ $reportType === 'best_selling' ? 'selected' : '' }}>
                            {{ trans('messages.best_selling_products') }}
                        </option>
                        <option value="worst_selling" {{ $reportType === 'worst_selling' ? 'selected' : '' }}>
                            {{ trans('messages.worst_selling_products') }}
                        </option>
                        <option value="most_profitable" {{ $reportType === 'most_profitable' ? 'selected' : '' }}>
                            {{ trans('messages.most_profitable_products') }}
                        </option>
                        <option value="least_profitable" {{ $reportType === 'least_profitable' ? 'selected' : '' }}>
                            {{ trans('messages.least_profitable_products') }}
                        </option>
                        <option value="highest_margin" {{ $reportType === 'highest_margin' ? 'selected' : '' }}>
                            {{ trans('messages.highest_margin_products') }}
                        </option>
                        <option value="lowest_margin" {{ $reportType === 'lowest_margin' ? 'selected' : '' }}>
                            {{ trans('messages.lowest_margin_products') }}
                        </option>
                        <option value="highest_revenue" {{ $reportType === 'highest_revenue' ? 'selected' : '' }}>
                            {{ trans('messages.highest_revenue_products') }}
                        </option>
                        <option value="most_active" {{ $reportType === 'most_active' ? 'selected' : '' }}>
                            {{ trans('messages.most_active_products') }}
                        </option>
                        <option value="unsold" {{ $reportType === 'unsold' ? 'selected' : '' }}>
                            {{ trans('messages.unsold_products') }}
                        </option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-2">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-2">
                    <label for="limit" class="form-label">{{ trans('messages.limit') }}</label>
                    <input type="number" name="limit" id="limit" class="form-control" value="{{ $limit }}" min="1" max="100">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">
                        <i class="bi bi-search"></i> {{ trans('messages.filter') }}
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            @if($reportType === 'best_selling')
                {{ trans('messages.best_selling_products') }}
            @elseif($reportType === 'worst_selling')
                {{ trans('messages.worst_selling_products') }}
            @elseif($reportType === 'most_profitable')
                {{ trans('messages.most_profitable_products') }}
            @elseif($reportType === 'least_profitable')
                {{ trans('messages.least_profitable_products') }}
            @elseif($reportType === 'highest_margin')
                {{ trans('messages.highest_margin_products') }}
            @elseif($reportType === 'lowest_margin')
                {{ trans('messages.lowest_margin_products') }}
            @elseif($reportType === 'highest_revenue')
                {{ trans('messages.highest_revenue_products') }}
            @elseif($reportType === 'most_active')
                {{ trans('messages.most_active_products') }}
            @elseif($reportType === 'unsold')
                {{ trans('messages.unsold_products') }}
            @endif
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.category') }}</th>
                        <th>{{ trans('messages.sku') }}</th>
                        @if($reportType !== 'unsold')
                            <th class="text-end">{{ trans('messages.quantity_sold') }}</th>
                            <th class="text-end">{{ trans('messages.total_revenue') }}</th>
                            <th class="text-end">{{ trans('messages.total_cost') }}</th>
                            <th class="text-end">{{ trans('messages.profit') }}</th>
                            <th class="text-end">{{ trans('messages.profit_margin') }} %</th>
                            @if($reportType === 'most_active')
                                <th class="text-end">{{ trans('messages.sales_count') }}</th>
                            @endif
                        @else
                            <th class="text-end">{{ trans('messages.stock_quantity') }}</th>
                            <th class="text-end">{{ trans('messages.purchase_price') }}</th>
                            <th class="text-end">{{ trans('messages.selling_price') }}</th>
                            <th class="text-end">{{ trans('messages.stock_value') }}</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @forelse($results as $index => $item)
                    @php
                        $product = $reportType === 'unsold' ? $item : $item['product'];
                        $isUnsold = $reportType === 'unsold';
                    @endphp
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <strong>{{ app()->getLocale() === 'ar' && $product->name_ar ? $product->name_ar : $product->name }}</strong>
                            @if($product->isLowStock())
                                <span class="badge bg-warning ms-2">{{ trans('messages.low_stock') }}</span>
                            @endif
                        </td>
                        <td>{{ $product->category ? (app()->getLocale() === 'ar' && $product->category->name_ar ? $product->category->name_ar : $product->category->name) : '-' }}</td>
                        <td>{{ $product->sku ?? '-' }}</td>
                        @if(!$isUnsold)
                            <td class="text-end">{{ number_format($item['quantity_sold'] ?? 0) }}</td>
                            <td class="text-end">{{ format_currency($item['total_revenue'] ?? 0) }}</td>
                            <td class="text-end">{{ format_currency($item['total_cost'] ?? 0) }}</td>
                            <td class="text-end">
                                <strong class="text-{{ ($item['profit'] ?? 0) >= 0 ? 'success' : 'danger' }}">
                                    {{ format_currency($item['profit'] ?? 0) }}
                                </strong>
                            </td>
                            <td class="text-end">
                                <span class="badge bg-{{ ($item['profit_margin'] ?? 0) >= 0 ? 'success' : 'danger' }}">
                                    {{ number_format($item['profit_margin'] ?? 0, 2) }}%
                                </span>
                            </td>
                            @if($reportType === 'most_active')
                                <td class="text-end">{{ number_format($item['sales_count'] ?? 0) }}</td>
                            @endif
                        @else
                            <td class="text-end">{{ number_format($product->stock_quantity ?? 0) }}</td>
                            <td class="text-end">{{ format_currency($product->purchase_price ?? 0) }}</td>
                            <td class="text-end">{{ format_currency($product->selling_price ?? 0) }}</td>
                            <td class="text-end">{{ format_currency(($product->stock_quantity ?? 0) * ($product->purchase_price ?? 0)) }}</td>
                        @endif
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ $reportType === 'unsold' ? '8' : ($reportType === 'most_active' ? '11' : '10') }}" class="text-center">
                            <div class="alert alert-info mb-0">
                                <i class="bi bi-info-circle"></i> {{ trans('messages.no_data_found') }}
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
                @if($results->count() > 0 && $reportType !== 'unsold')
                <tfoot>
                    <tr class="table-info">
                        <th colspan="4" class="text-end">{{ trans('messages.total') }}:</th>
                        <th class="text-end">{{ number_format($results->sum('quantity_sold')) }}</th>
                        <th class="text-end">{{ format_currency($results->sum('total_revenue')) }}</th>
                        <th class="text-end">{{ format_currency($results->sum('total_cost')) }}</th>
                        <th class="text-end">{{ format_currency($results->sum('profit')) }}</th>
                        <th class="text-end">
                            {{ $results->sum('total_revenue') > 0 ? number_format(($results->sum('profit') / $results->sum('total_revenue')) * 100, 2) : 0 }}%
                        </th>
                        @if($reportType === 'most_active')
                            <th class="text-end">{{ number_format($results->sum('sales_count')) }}</th>
                        @endif
                    </tr>
                </tfoot>
                @endif
            </table>
        </div>
    </div>
</div>
@endsection

