@extends('layouts.master')

@section('title', trans('messages.promissory_notes'))

@section('content')
@php
    $isRTL = app()->getLocale() === 'ar';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.promissory_notes') }}</h2>
    <div>
        <a href="{{ route('promissory-notes.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_promissory_note') }}</a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('promissory-notes.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="type" class="form-select">
                        <option value="">{{ trans('messages.all') }}</option>
                        <option value="customer" {{ request('type') === 'customer' ? 'selected' : '' }}>{{ trans('messages.customers') }}</option>
                        <option value="supplier" {{ request('type') === 'supplier' ? 'selected' : '' }}>{{ trans('messages.suppliers') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_status') }}</option>
                        <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>{{ trans('messages.pending') }}</option>
                        <option value="due" {{ request('status') === 'due' ? 'selected' : '' }}>{{ trans('messages.due') }}</option>
                        <option value="paid" {{ request('status') === 'paid' ? 'selected' : '' }}>{{ trans('messages.paid') }}</option>
                        <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>{{ trans('messages.cancelled') }}</option>
                    </select>
                </div>
                @if($customers->count() > 0)
                <div class="col-md-2">
                    <select name="customer_id" class="form-select">
                        <option value="">{{ trans('messages.all_customers') }}</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                        @endforeach
                    </select>
                </div>
                @endif
                @if($suppliers->count() > 0)
                <div class="col-md-2">
                    <select name="supplier_id" class="form-select">
                        <option value="">{{ trans('messages.all_suppliers') }}</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
                        @endforeach
                    </select>
                </div>
                @endif
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.search') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ trans('messages.note_number') }}</th>
                        <th>{{ trans('messages.type') }}</th>
                        <th>{{ trans('messages.name') }}</th>
                        <th>{{ trans('messages.amount') }}</th>
                        <th>{{ trans('messages.issue_date') }}</th>
                        <th>{{ trans('messages.due_date') }}</th>
                        <th>{{ trans('messages.status') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($promissoryNotes as $note)
                    <tr>
                        <td><strong>{{ $note->note_number }}</strong></td>
                        <td>
                            <span class="badge bg-{{ $note->type === 'customer' ? 'info' : 'warning' }}">
                                {{ $note->type === 'customer' ? trans('messages.customers') : trans('messages.suppliers') }}
                            </span>
                        </td>
                        <td>
                            @if($note->type === 'customer')
                                <a href="{{ route('customers.show', $note->customer_id) }}">{{ $note->customer->name ?? 'N/A' }}</a>
                            @else
                                <a href="{{ route('suppliers.edit', $note->supplier_id) }}">{{ $note->supplier->name ?? 'N/A' }}</a>
                            @endif
                        </td>
                        <td><strong>{{ format_currency($note->amount) }}</strong></td>
                        <td>{{ $note->issue_date->format('Y-m-d') }}</td>
                        <td>
                            <span class="{{ $note->due_date < now() && !$note->isPaid() ? 'text-danger' : '' }}">
                                {{ $note->due_date->format('Y-m-d') }}
                            </span>
                        </td>
                        <td>
                            @php
                                $badgeClass = match($note->status) {
                                    'paid' => 'success',
                                    'due' => 'warning',
                                    'cancelled' => 'secondary',
                                    default => 'info'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $note->status) }}</span>
                        </td>
                        <td>
                            <a href="{{ route('promissory-notes.show', $note) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') }}"><i class="bi bi-eye"></i></a>
                            @if(!$note->isPaid())
                                <a href="{{ route('promissory-notes.edit', $note) }}" class="btn btn-sm btn-warning" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></a>
                            @endif
                            @if(!$note->isPaid())
                                <form action="{{ route('promissory-notes.destroy', $note) }}" method="POST" class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}"><i class="bi bi-trash"></i></button>
                                </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">{{ trans('messages.no_promissory_notes_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $promissoryNotes->links() }}
    </div>
</div>
@endsection

