@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $footerText = \App\Models\Setting::get('invoice_footer_text', '');
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $showBarcode = \App\Models\Setting::get('purchase_invoice_show_barcode', '1') === '1';
    $showLogo = \App\Models\Setting::get('purchase_invoice_show_logo', '1') === '1';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ trans('messages.purchase_invoice') }} {{ $purchaseInvoice->invoice_number }}</title>
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', DejaVu Sans, sans-serif" : "DejaVu Sans, 'Cabin', sans-serif" }};
            direction: {{ $dir }};
            font-size: 12px;
            color: #333;
            padding: 20px;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', DejaVu Sans, sans-serif !important;
        }
        @else
        * {
            font-family: DejaVu Sans, 'Cabin', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .invoice-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .invoice-info h2 {
            margin-bottom: 10px;
            color: #333;
        }
        
        .invoice-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        
        .supplier-info, .invoice-meta {
            width: 48%;
        }
        
        .supplier-info h3, .invoice-meta h3 {
            margin-bottom: 10px;
            font-size: 14px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
        }
        
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        
        .text-{{ $isRTL ? 'start' : 'end' }} {
            text-align: {{ $isRTL ? 'left' : 'right' }};
        }
        
        .total-table {
            width: 100%;
            max-width: 400px;
            margin-top: 20px;
            {{ $isRTL ? 'margin-right: auto;' : 'margin-left: auto;' }}
            border-collapse: collapse;
        }
        
        .total-table td {
            padding: 6px 12px;
            border: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .total-table td:first-child {
            font-weight: bold;
            background-color: #f9f9f9;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .total-table td:last-child {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
            font-weight: normal;
        }
        
        .total-table .total-row td {
            background-color: #e9ecef;
            font-weight: bold;
            font-size: 14px;
            border-top: 2px solid #333;
        }
        
        .total-table .total-row td:last-child {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo-container">
            @if($showLogo && $storeLogo)
                <img src="{{ \Storage::disk('public')->path($storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="invoice-info">
            <h2>{{ trans('messages.purchase_invoice') }} #{{ $purchaseInvoice->invoice_number }}</h2>
            <p><strong>{{ trans('messages.date') }}:</strong> {{ $purchaseInvoice->purchase_date->format('Y-m-d') }}</p>
            <p><strong>{{ trans('messages.status') }}:</strong> {{ trans('messages.' . $purchaseInvoice->status) }}</p>
        </div>
    </div>

    <div class="invoice-details">
        <div class="supplier-info">
            <h3>{{ trans('messages.suppliers') }}</h3>
            <p><strong>{{ trans('messages.name') }}:</strong> {{ $purchaseInvoice->supplier->name }}</p>
            @if($purchaseInvoice->supplier->email)
                <p><strong>{{ trans('messages.email') }}:</strong> {{ $purchaseInvoice->supplier->email }}</p>
            @endif
            @if($purchaseInvoice->supplier->phone)
                <p><strong>{{ trans('messages.phone') }}:</strong> {{ $purchaseInvoice->supplier->phone }}</p>
            @endif
            @if($purchaseInvoice->supplier->address)
                <p><strong>{{ trans('messages.address') }}:</strong> {{ $purchaseInvoice->supplier->address }}</p>
            @endif
        </div>
        <div class="invoice-meta">
            <h3>{{ trans('messages.purchase_invoice_details') }}</h3>
            <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $purchaseInvoice->user->name }}</p>
            <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $purchaseInvoice->invoice_number }}</p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>{{ trans('messages.products') }}</th>
                @if($showBarcode)
                <th>{{ trans('messages.barcode') }}</th>
                @endif
                <th>{{ trans('messages.quantity') }}</th>
                <th>{{ trans('messages.purchase_price') }}</th>
                <th>{{ trans('messages.tax') }}</th>
                <th>{{ trans('messages.total') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($purchaseInvoice->items as $item)
            <tr>
                <td>{{ $item->product->name }}</td>
                @if($showBarcode)
                <td>{{ $item->product->barcode ?? '-' }}</td>
                @endif
                <td>{{ $item->quantity }}</td>
                <td>{{ number_format($item->purchase_price, 2) }} {{ $currency }}</td>
                <td>{{ number_format($item->tax, 2) }} {{ $currency }}</td>
                <td>{{ number_format($item->total, 2) }} {{ $currency }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="total-table">
        <tr>
            <td>{{ trans('messages.subtotal') }}</td>
            <td>{{ number_format($purchaseInvoice->subtotal, 2) }} {{ $currency }}</td>
        </tr>
        @if($purchaseInvoice->discount > 0)
        <tr>
            <td>{{ trans('messages.discount') }}</td>
            <td>-{{ number_format($purchaseInvoice->discount, 2) }} {{ $currency }}</td>
        </tr>
        @endif
        <tr>
            <td>{{ trans('messages.tax') }}</td>
            <td>{{ number_format($purchaseInvoice->tax, 2) }} {{ $currency }}</td>
        </tr>
        <tr class="total-row">
            <td>{{ trans('messages.total_amount') }}</td>
            <td>{{ number_format($purchaseInvoice->total_amount, 2) }} {{ $currency }}</td>
        </tr>
        <tr>
            <td>{{ trans('messages.amount_paid') }}</td>
            <td>{{ number_format($purchaseInvoice->amount_paid, 2) }} {{ $currency }}</td>
        </tr>
        <tr>
            <td>{{ trans('messages.amount_remaining') }}</td>
            <td style="font-weight: bold;">{{ number_format($purchaseInvoice->amount_remaining, 2) }} {{ $currency }}</td>
        </tr>
    </table>

    @if($purchaseInvoice->notes)
    <div style="margin-top: 20px;">
        <p><strong>{{ trans('messages.notes') }}:</strong></p>
        <p>{{ $purchaseInvoice->notes }}</p>
    </div>
    @endif

    @if($footerText)
    <div class="footer">
        <p>{{ $footerText }}</p>
    </div>
    @endif
</body>
</html>
