@extends('layouts.master')

@section('title', trans('messages.purchase_invoice_details'))

@section('content')
@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $isRTL = app()->getLocale() === 'ar';
    $showBarcode = \App\Models\Setting::get('purchase_invoice_show_barcode', '1') === '1';
    $showLogo = \App\Models\Setting::get('purchase_invoice_show_logo', '1') === '1';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.invoice_number') }}: {{ $purchaseInvoice->invoice_number }}</h2>
    <div>
        @can('purchase-invoices.confirm')
            @if($purchaseInvoice->isDraft())
                <form action="{{ route('purchase-invoices.confirm', $purchaseInvoice) }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-success"><i class="bi bi-check-circle"></i> {{ trans('messages.confirm') }}</button>
                </form>
            @endif
        @endcan
        @can('purchase-invoices.update')
            @if($purchaseInvoice->isDraft())
                <a href="{{ route('purchase-invoices.edit', $purchaseInvoice) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
            @endif
        @endcan
        @can('purchase-invoices.return')
            @if($purchaseInvoice->isConfirmed() && !$purchaseInvoice->isReturned())
                <form action="{{ route('purchase-invoices.return', $purchaseInvoice) }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-warning" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-box-arrow-left"></i> {{ trans('messages.return_invoice_items') }}</button>
                </form>
            @endif
        @endcan
        @can('purchase-invoices.print')
            <a href="{{ route('purchase-invoices.print', $purchaseInvoice) }}" class="btn btn-info position-relative" target="_blank" onclick="markDocumentAsExported('purchase-invoice-{{ $purchaseInvoice->id }}', 'print'); showPrintNotification('{{ trans('messages.print') }}')">
                <i class="bi bi-printer"></i> {{ trans('messages.print') }}
                <span id="export-badge-print-{{ $purchaseInvoice->id }}" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-info" style="display: none;">
                    <i class="bi bi-check-circle"></i>
                </span>
            </a>
        @endcan
        @can('purchase-invoices.print')
            <a href="{{ route('purchase-invoices.bon-commande', $purchaseInvoice) }}" class="btn btn-primary position-relative" target="_blank" onclick="markDocumentAsExported('purchase-invoice-{{ $purchaseInvoice->id }}', 'purchase_order'); showPrintNotification('{{ trans('messages.purchase_order') }}')">
                <i class="bi bi-file-earmark-text"></i> {{ trans('messages.purchase_order') }}
                <span id="export-badge-purchase_order-{{ $purchaseInvoice->id }}" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-primary" style="display: none;">
                    <i class="bi bi-check-circle"></i>
                </span>
            </a>
        @endcan
        @can('purchase-invoices.delete')
            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deletePurchaseInvoiceModal">
                <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
            </button>
        @endcan
        <a href="{{ route('purchase-invoices.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

@if(auth()->user()->hasAnyRole(['Admin', 'Super Admin']))
<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deletePurchaseInvoiceModal" tabindex="-1" aria-labelledby="deletePurchaseInvoiceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deletePurchaseInvoiceModalLabel">{{ trans('messages.confirm_delete') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>{{ trans('messages.confirm_delete_purchase_invoice') }}</p>
                <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $purchaseInvoice->invoice_number }}</p>
                @if(!$purchaseInvoice->isReturned() && ($purchaseInvoice->isConfirmed() || $purchaseInvoice->status === 'paid' || $purchaseInvoice->status === 'partially_paid'))
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.stock_will_be_reversed') }}
                    </div>
                @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                <form action="{{ route('purchase-invoices.destroy', $purchaseInvoice) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ trans('messages.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6 invoice-logo-container">
                        @if($showLogo && $storeLogo)
                            <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}" class="invoice-logo">
                        @else
                            <h4>{{ $storeName }}</h4>
                        @endif
                    </div>
                    <div class="col-md-6 {{ $isRTL ? 'text-start' : 'text-end' }}">
                        <h4>{{ trans('messages.purchase_invoice') }}</h4>
                        <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $purchaseInvoice->invoice_number }}</p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.suppliers') }}:</strong> {{ $purchaseInvoice->supplier->name }}</p>
                        <p><strong>{{ trans('messages.purchase_date') }}:</strong> {{ $purchaseInvoice->purchase_date->format('Y-m-d') }}</p>
                    </div>
                    <div class="col-md-6 {{ $isRTL ? 'text-start' : 'text-end' }}">
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            @php
                                $badgeClass = match($purchaseInvoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    'confirmed' => 'info',
                                    default => 'warning'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $purchaseInvoice->status) }}</span>
                        </p>
                        <p><strong>{{ trans('messages.date') }}:</strong> {{ $purchaseInvoice->created_at->format('Y-m-d H:i') }}</p>
                        <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $purchaseInvoice->user->name }}</p>
                        <div id="exported-documents-{{ $purchaseInvoice->id }}" class="mt-2" style="display: none;">
                            <small class="text-muted d-block mb-1">{{ trans('messages.exported_documents') }}:</small>
                            <div id="exported-badges-{{ $purchaseInvoice->id }}"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.items') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.products') }}</th>
                                @if($showBarcode)
                                <th>{{ trans('messages.barcode') }}</th>
                                @endif
                                <th>{{ trans('messages.quantity') }}</th>
                                <th>{{ trans('messages.purchase_price') }}</th>
                                <th>{{ trans('messages.batch_number') }}</th>
                                <th>{{ trans('messages.expiry_date') }}</th>
                                <th>{{ trans('messages.tax') }}</th>
                                <th>{{ trans('messages.total') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($purchaseInvoice->items as $item)
                            <tr>
                                <td>{{ $item->product->name }}</td>
                                @if($showBarcode)
                                <td>{{ $item->product->barcode ?? '-' }}</td>
                                @endif
                                <td>{{ $item->quantity }}</td>
                                <td>{{ format_currency($item->purchase_price) }}</td>
                                <td>
                                    @if($item->batch_number)
                                        <span class="badge bg-info">{{ $item->batch_number }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($item->expiry_date)
                                        {{ $item->expiry_date->format('Y-m-d') }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>{{ format_currency($item->tax) }}</td>
                                <td>{{ format_currency($item->total) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="{{ $showBarcode ? '7' : '6' }}" class="text-end"><strong>{{ trans('messages.subtotal') }}:</strong></td>
                                <td><strong>{{ format_currency($purchaseInvoice->subtotal) }}</strong></td>
                            </tr>
                            @if($purchaseInvoice->discount > 0)
                            <tr>
                                <td colspan="{{ $showBarcode ? '7' : '6' }}" class="text-end"><strong>{{ trans('messages.discount') }}:</strong></td>
                                <td><strong>-{{ format_currency($purchaseInvoice->discount) }}</strong></td>
                            </tr>
                            @endif
                            <tr>
                                <td colspan="{{ $showBarcode ? '7' : '6' }}" class="text-end"><strong>{{ trans('messages.tax') }}:</strong></td>
                                <td><strong>{{ format_currency($purchaseInvoice->tax) }}</strong></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $showBarcode ? '5' : '4' }}" class="text-end"><strong>{{ trans('messages.total_amount') }}:</strong></td>
                                <td><strong>{{ format_currency($purchaseInvoice->total_amount) }}</strong></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $showBarcode ? '5' : '4' }}" class="text-end"><strong>{{ trans('messages.amount_paid') }}:</strong></td>
                                <td><strong>{{ format_currency($purchaseInvoice->amount_paid) }}</strong></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $showBarcode ? '5' : '4' }}" class="text-end"><strong>{{ trans('messages.amount_remaining') }}:</strong></td>
                                <td><strong class="text-{{ $purchaseInvoice->amount_remaining > 0 ? 'warning' : 'success' }}">{{ format_currency($purchaseInvoice->amount_remaining) }}</strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        @if($purchaseInvoice->notes)
        <div class="card mb-3">
            <div class="card-body">
                <strong>{{ trans('messages.notes') }}:</strong>
                <p>{{ $purchaseInvoice->notes }}</p>
            </div>
        </div>
        @endif

        @if($purchaseInvoice->supplier_invoice_file)
        <div class="card mb-3">
            <div class="card-body">
                <strong>{{ trans('messages.supplier_invoice_file') }}:</strong>
                <a href="{{ storage_url( $purchaseInvoice->supplier_invoice_file) }}" target="_blank" class="btn btn-sm btn-info"><i class="bi bi-file-earmark-pdf"></i> {{ trans('messages.view') }}</a>
            </div>
        </div>
        @endif
    </div>
    <div class="col-md-4">
        @if(!$purchaseInvoice->isDraft() && !$purchaseInvoice->isReturned() && $purchaseInvoice->amount_remaining > 0)
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.record_payment') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('supplier-payments.store', $purchaseInvoice) }}">
                    @csrf
                    <div class="mb-3">
                        <label for="amount_paid" class="form-label">{{ trans('messages.amount') }} *</label>
                        <div class="input-group">
                            <input type="number" step="0.01" class="form-control" id="amount_paid" name="amount_paid" max="{{ $purchaseInvoice->amount_remaining }}" required>
                            <button type="button" class="btn btn-outline-secondary" id="fillTotalAmount" title="{{ trans('messages.fill_total_amount') }}">
                                <i class="bi bi-arrow-down-circle"></i> {{ trans('messages.total') }}
                            </button>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">{{ trans('messages.payment_method') }} *</label>
                        <select class="form-select" id="payment_method" name="payment_method" required>
                            <option value="cash">{{ trans('messages.cash') }}</option>
                            <option value="bank_transfer">{{ trans('messages.bank_transfer') }}</option>
                            <option value="credit">{{ trans('messages.credit') }}</option>
                            <option value="cheque">{{ trans('messages.cheque') }}</option>
                            <option value="promissory_note">{{ trans('messages.promissory_note') }}</option>
                            <option value="online">{{ trans('messages.online') }}</option>
                            <option value="other">{{ trans('messages.other') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="payment_reference" class="form-label">{{ trans('messages.payment_reference') }}</label>
                        <input type="text" class="form-control" id="payment_reference" name="payment_reference">
                    </div>
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">{{ trans('messages.date') }}</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}">
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">{{ trans('messages.record_payment') }}</button>
                </form>
            </div>
        </div>
        @endif

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.payment_history') }}</h5>
            </div>
            <div class="card-body">
                @if($purchaseInvoice->payments->count() > 0)
                    <div class="list-group">
                        @foreach($purchaseInvoice->payments as $payment)
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between">
                                <div style="flex: 1;">
                                    <strong>{{ format_currency($payment->amount_paid) }}</strong><br>
                                    <small class="text-muted">{{ trans('messages.' . $payment->payment_method) }} - {{ $payment->payment_date->format('Y-m-d') }}</small>
                                    @if($payment->payment_reference)
                                        <br><small class="text-muted">{{ trans('messages.payment_reference') }}: {{ $payment->payment_reference }}</small>
                                    @endif
                                    @if($payment->payment_method === 'cheque')
                                        <br>
                                        <a href="{{ route('cheques.create', ['type' => 'supplier', 'supplier_id' => $purchaseInvoice->supplier_id, 'purchase_invoice_id' => $purchaseInvoice->id, 'amount' => $payment->amount_paid]) }}" 
                                           class="btn btn-sm btn-outline-primary mt-2">
                                            <i class="bi bi-bank"></i> {{ trans('messages.add_cheque') }}
                                        </a>
                                    @elseif($payment->payment_method === 'promissory_note')
                                        <br>
                                        <a href="{{ route('promissory-notes.create', ['type' => 'supplier', 'supplier_id' => $purchaseInvoice->supplier_id, 'purchase_invoice_id' => $purchaseInvoice->id, 'amount' => $payment->amount_paid]) }}" 
                                           class="btn btn-sm btn-outline-primary mt-2">
                                            <i class="bi bi-file-text"></i> {{ trans('messages.add_promissory_note') }}
                                        </a>
                                    @endif
                                </div>
                                <form action="{{ route('supplier-payments.destroy', $payment) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-muted">{{ trans('messages.no_payments') }}</p>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Track exported documents
    const purchaseInvoiceId = {{ $purchaseInvoice->id }};
    
    // Initialize exported documents display
    document.addEventListener('DOMContentLoaded', function() {
        checkExportedDocuments();
    });

    function checkExportedDocuments() {
        const exportedDocs = JSON.parse(localStorage.getItem('exported_documents_' + purchaseInvoiceId) || '{}');
        const exportedDiv = document.getElementById('exported-documents-' + purchaseInvoiceId);
        const badgesDiv = document.getElementById('exported-badges-' + purchaseInvoiceId);
        
        if (Object.keys(exportedDocs).length > 0) {
            exportedDiv.style.display = 'block';
            badgesDiv.innerHTML = '';
            
            const documentTypes = {
                'print': '{{ trans("messages.print") }}',
                'purchase_order': '{{ trans("messages.purchase_order") }}'
            };
            
            const documentColors = {
                'print': 'info',
                'purchase_order': 'primary'
            };
            
            Object.keys(exportedDocs).forEach(function(docType) {
                if (exportedDocs[docType]) {
                    const badge = document.createElement('span');
                    const color = documentColors[docType] || 'success';
                    badge.className = 'badge bg-' + color + ' me-1 mb-1';
                    badge.innerHTML = '<i class="bi bi-check-circle"></i> ' + (documentTypes[docType] || docType);
                    badgesDiv.appendChild(badge);
                    
                    // Show badge on button
                    const buttonBadge = document.getElementById('export-badge-' + docType + '-' + purchaseInvoiceId);
                    if (buttonBadge) {
                        buttonBadge.style.display = 'inline-block';
                    }
                }
            });
        }
    }

    function markDocumentAsExported(invoiceKey, documentType) {
        const exportedDocs = JSON.parse(localStorage.getItem('exported_documents_' + purchaseInvoiceId) || '{}');
        exportedDocs[documentType] = true;
        localStorage.setItem('exported_documents_' + purchaseInvoiceId, JSON.stringify(exportedDocs));
        
        // Update display
        setTimeout(function() {
            checkExportedDocuments();
        }, 100);
    }

    // Toast notification for print actions
    function showPrintNotification(documentType) {
        const message = '{{ trans("messages.document_printed_successfully") }}'.replace(':document', documentType);
        showToastNotification(message, 'success');
    }

    function showToastNotification(message, type = 'success') {
        // Create toast container if it doesn't exist
        let toastContainer = document.getElementById('toast-container');
        if (!toastContainer) {
            toastContainer = document.createElement('div');
            toastContainer.id = 'toast-container';
            toastContainer.className = 'toast-container position-fixed {{ $isRTL ? "start-0" : "end-0" }} p-3';
            toastContainer.style.cssText = 'top: 80px; z-index: 9999;';
            document.body.appendChild(toastContainer);
        }

        // Create toast element
        const toastId = 'toast-' + Date.now();
        const toast = document.createElement('div');
        toast.id = toastId;
        toast.className = 'toast align-items-center text-white bg-' + (type === 'success' ? 'success' : 'danger') + ' border-0';
        toast.setAttribute('role', 'alert');
        toast.setAttribute('aria-live', 'assertive');
        toast.setAttribute('aria-atomic', 'true');
        
        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">
                    <i class="bi bi-${type === 'success' ? 'check-circle' : 'exclamation-triangle'}-fill me-2"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        `;
        
        toastContainer.appendChild(toast);
        
        // Initialize and show toast
        const bsToast = new bootstrap.Toast(toast, {
            autohide: true,
            delay: 4000
        });
        
        bsToast.show();
        
        // Remove toast element after it's hidden
        toast.addEventListener('hidden.bs.toast', function() {
            toast.remove();
        });
    }

    // Fill total amount button functionality
    document.addEventListener('DOMContentLoaded', function() {
        const fillTotalBtn = document.getElementById('fillTotalAmount');
        const amountInput = document.getElementById('amount_paid');
        const totalAmount = {{ $purchaseInvoice->total_amount }};
        const maxAmount = {{ $purchaseInvoice->amount_remaining }};
        
        if (fillTotalBtn && amountInput) {
            fillTotalBtn.addEventListener('click', function() {
                // Fill with total amount, but not more than remaining amount
                const fillAmount = Math.min(totalAmount, maxAmount);
                amountInput.value = fillAmount.toFixed(2);
                // Trigger input event to ensure validation
                amountInput.dispatchEvent(new Event('input'));
            });
        }
    });
</script>
@endpush
@endsection

