@extends('layouts.master')

@section('title', trans('messages.create_purchase_order'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.create_purchase_order') }}</h2>
    <a href="{{ route('purchase-orders.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('purchase-orders.store') }}" id="purchase-order-form">
            @csrf
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="supplier_id" class="form-label">{{ trans('messages.supplier') }}</label>
                    <select class="form-select" id="supplier_id" name="supplier_id">
                        <option value="">{{ trans('messages.select_supplier') }}</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="expected_delivery_date" class="form-label">{{ trans('messages.expected_delivery_date') }}</label>
                    <input type="date" class="form-control" id="expected_delivery_date" name="expected_delivery_date">
                </div>
            </div>

            <hr>

            <h5>{{ trans('messages.items') }}</h5>
            <div class="table-responsive mb-3">
                <table class="table" id="items-table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.product') }}</th>
                            <th>{{ trans('messages.quantity') }}</th>
                            <th>{{ trans('messages.unit_price') }}</th>
                            <th>{{ trans('messages.total') }}</th>
                            <th>{{ trans('messages.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody id="items-tbody">
                        <tr class="item-row">
                            <td>
                                <select class="form-select product-select" name="items[0][product_id]" required>
                                    <option value="">{{ trans('messages.select_product') }}</option>
                                    @foreach($products as $product)
                                        <option value="{{ $product->id }}" data-price="{{ $product->purchase_price }}">{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td><input type="number" class="form-control quantity" name="items[0][quantity]" min="1" value="1" required></td>
                            <td><input type="number" step="0.01" class="form-control unit-price" name="items[0][unit_price]" required></td>
                            <td><span class="item-total">0.00</span> {{ currency_symbol() }}</td>
                            <td><button type="button" class="btn btn-sm btn-danger remove-item"><i class="bi bi-trash"></i></button></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <button type="button" class="btn btn-sm btn-primary mb-3" id="add-item"><i class="bi bi-plus"></i> {{ trans('messages.add_item') }}</button>

            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">{{ trans('messages.save') }}</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
let itemIndex = 1;

document.getElementById('add-item').addEventListener('click', function() {
    const tbody = document.getElementById('items-tbody');
    const newRow = tbody.querySelector('.item-row').cloneNode(true);
    
    newRow.querySelectorAll('input, select').forEach(input => {
        if (input.name) {
            input.name = input.name.replace(/\[0\]/, `[${itemIndex}]`);
        }
        if (input.classList.contains('product-select')) {
            input.value = '';
        } else if (input.classList.contains('quantity')) {
            input.value = 1;
        } else if (input.classList.contains('unit-price')) {
            input.value = '';
        }
    });
    
    newRow.querySelector('.item-total').textContent = '0.00';
    tbody.appendChild(newRow);
    itemIndex++;
});

document.addEventListener('click', function(e) {
    if (e.target.closest('.remove-item')) {
        const tbody = document.getElementById('items-tbody');
        if (tbody.children.length > 1) {
            e.target.closest('.item-row').remove();
        }
    }
});

document.addEventListener('change', function(e) {
    if (e.target.classList.contains('product-select')) {
        const price = e.target.options[e.target.selectedIndex].dataset.price;
        const row = e.target.closest('.item-row');
        row.querySelector('.unit-price').value = price || '';
        calculateRowTotal(row);
    }
});

document.addEventListener('input', function(e) {
    if (e.target.classList.contains('quantity') || e.target.classList.contains('unit-price')) {
        calculateRowTotal(e.target.closest('.item-row'));
    }
});

function calculateRowTotal(row) {
    const quantity = parseFloat(row.querySelector('.quantity').value) || 0;
    const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
    const total = quantity * unitPrice;
    row.querySelector('.item-total').textContent = total.toFixed(2);
}
</script>
@endpush
@endsection

