@extends('layouts.master')

@section('title', trans('messages.purchase_order'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.order_number') }}: {{ $purchaseOrder->order_number }}</h2>
    <div>
        @if($purchaseOrder->isDraft())
            <a href="{{ route('purchase-orders.edit', $purchaseOrder) }}" class="btn btn-warning">
                <i class="bi bi-pencil"></i> {{ trans('messages.edit') }}
            </a>
        @endif
        @if($purchaseOrder->status === 'pending')
            <form action="{{ route('purchase-orders.approve', $purchaseOrder) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-success">
                    <i class="bi bi-check-circle"></i> {{ trans('messages.approve') }}
                </button>
            </form>
        @endif
        @if($purchaseOrder->supplier_id && ($purchaseOrder->status === 'approved' || $purchaseOrder->status === 'pending' || $purchaseOrder->status === 'draft'))
            <form action="{{ route('purchase-orders.convert-to-invoice', $purchaseOrder) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-primary" onclick="return confirm('{{ trans('messages.confirm_convert_to_purchase_invoice') }}')">
                    <i class="bi bi-file-earmark-text"></i> {{ trans('messages.convert_to_purchase_invoice') }}
                </button>
            </form>
        @endif
        @if($purchaseOrder->isDraft())
            <form action="{{ route('purchase-orders.destroy', $purchaseOrder) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}')">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger">
                    <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                </button>
            </form>
        @endif
        <a href="{{ route('purchase-orders.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.order_details') }}</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.supplier') }}:</strong> {{ $purchaseOrder->supplier?->name ?? '-' }}</p>
                        <p><strong>{{ trans('messages.expected_delivery_date') }}:</strong> {{ $purchaseOrder->expected_delivery_date ? $purchaseOrder->expected_delivery_date->format('Y-m-d') : '-' }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            @php
                                $badgeClass = match($purchaseOrder->status) {
                                    'draft' => 'secondary',
                                    'pending' => 'warning',
                                    'approved' => 'success',
                                    'completed' => 'primary',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $purchaseOrder->status) }}</span>
                        </p>
                        <p><strong>{{ trans('messages.generation_type') }}:</strong> 
                            <span class="badge bg-{{ $purchaseOrder->generation_type === 'auto' ? 'info' : 'secondary' }}">
                                {{ trans('messages.' . $purchaseOrder->generation_type) }}
                            </span>
                        </p>
                    </div>
                </div>

                @if($purchaseOrder->notes)
                <div class="mb-3">
                    <strong>{{ trans('messages.notes') }}:</strong>
                    <p>{{ $purchaseOrder->notes }}</p>
                </div>
                @endif

                <h5 class="mt-4">{{ trans('messages.items') }}</h5>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th>{{ trans('messages.quantity') }}</th>
                                <th>{{ trans('messages.unit_price') }}</th>
                                <th>{{ trans('messages.total') }}</th>
                                <th>{{ trans('messages.received_quantity') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($purchaseOrder->items as $item)
                            <tr>
                                <td>{{ $item->product->name }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>{{ format_currency($item->unit_price) }}</td>
                                <td>{{ format_currency($item->total) }}</td>
                                <td>
                                    <span class="badge bg-{{ $item->isFullyReceived() ? 'success' : 'warning' }}">
                                        {{ $item->received_quantity }} / {{ $item->quantity }}
                                    </span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end">{{ trans('messages.total') }}:</th>
                                <th>{{ format_currency($purchaseOrder->total_amount) }}</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.information') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $purchaseOrder->creator->name ?? '-' }}</p>
                <p><strong>{{ trans('messages.created_at') }}:</strong> {{ $purchaseOrder->created_at->format('Y-m-d H:i') }}</p>
                @if($purchaseOrder->approver)
                    <p><strong>{{ trans('messages.approved_by') }}:</strong> {{ $purchaseOrder->approver->name }}</p>
                    <p><strong>{{ trans('messages.approved_at') }}:</strong> {{ $purchaseOrder->approved_at->format('Y-m-d H:i') }}</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

