@extends('layouts.master')

@section('title', trans('messages.complaint_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.complaint_details') }}: {{ $complaint->complaint_number }}</h2>
    <div>
        @can('quality.complaints.update')
            <a href="{{ route('quality.complaints.edit', $complaint) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        @endcan
        <a href="{{ route('quality.complaints.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <h4>{{ $complaint->complaint_number }}</h4>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.complaint_type') }}:</strong> {{ trans('messages.complaint_type_' . $complaint->complaint_type) }}</p>
                        @if($complaint->product)
                        <p><strong>{{ trans('messages.product') }}:</strong> 
                            <a href="{{ route('products.show', $complaint->product) }}">{{ $complaint->product->name }}</a>
                        </p>
                        @endif
                        @if($complaint->customer)
                        <p><strong>{{ trans('messages.customer') }}:</strong> 
                            <a href="{{ route('customers.show', $complaint->customer) }}">{{ $complaint->customer->name }}</a>
                        </p>
                        @endif
                        @if($complaint->supplier)
                        <p><strong>{{ trans('messages.supplier') }}:</strong> 
                            <a href="{{ route('suppliers.show', $complaint->supplier) }}">{{ $complaint->supplier->name }}</a>
                        </p>
                        @endif
                        @if($complaint->invoice)
                        <p><strong>{{ trans('messages.invoice') }}:</strong> 
                            <a href="{{ route('invoices.show', $complaint->invoice) }}">{{ $complaint->invoice->invoice_number }}</a>
                        </p>
                        @endif
                        @if($complaint->purchaseInvoice)
                        <p><strong>{{ trans('messages.purchase_invoice') }}:</strong> 
                            <a href="{{ route('purchase-invoices.show', $complaint->purchaseInvoice) }}">{{ $complaint->purchaseInvoice->invoice_number }}</a>
                        </p>
                        @endif
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.severity') }}:</strong> 
                            <span class="badge bg-{{ $complaint->getSeverityBadgeClass() }}">
                                {{ trans('messages.severity_' . $complaint->severity) }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            <span class="badge bg-{{ $complaint->getStatusBadgeClass() }}">
                                {{ trans('messages.status_' . $complaint->status) }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.reported_date') }}:</strong> {{ $complaint->reported_date->format('Y-m-d') }}</p>
                        @if($complaint->resolved_date)
                        <p><strong>{{ trans('messages.resolved_date') }}:</strong> {{ $complaint->resolved_date->format('Y-m-d') }}</p>
                        @endif
                        @if($complaint->reportedBy)
                        <p><strong>{{ trans('messages.reported_by') }}:</strong> {{ $complaint->reportedBy->name }}</p>
                        @endif
                        @if($complaint->assignedTo)
                        <p><strong>{{ trans('messages.assigned_to') }}:</strong> {{ $complaint->assignedTo->name }}</p>
                        @endif
                        @if($complaint->complainant_name)
                        <p><strong>{{ trans('messages.complainant_name') }}:</strong> {{ $complaint->complainant_name }}</p>
                        @endif
                        @if($complaint->complainant_email)
                        <p><strong>{{ trans('messages.complainant_email') }}:</strong> {{ $complaint->complainant_email }}</p>
                        @endif
                        @if($complaint->complainant_phone)
                        <p><strong>{{ trans('messages.complainant_phone') }}:</strong> {{ $complaint->complainant_phone }}</p>
                        @endif
                    </div>
                </div>

                <hr>

                <div class="mb-3">
                    <strong>{{ trans('messages.description') }}:</strong>
                    <p>{{ $complaint->description }}</p>
                </div>

                @if($complaint->description_ar)
                <div class="mb-3">
                    <strong>{{ trans('messages.description_ar') }}:</strong>
                    <p>{{ $complaint->description_ar }}</p>
                </div>
                @endif

                @if($complaint->resolution_notes)
                <div class="mb-3">
                    <strong>{{ trans('messages.resolution_notes') }}:</strong>
                    <p>{{ $complaint->resolution_notes }}</p>
                </div>
                @endif

                @if($complaint->images && count($complaint->images) > 0)
                <hr>
                <strong>{{ trans('messages.images') }}:</strong>
                <div class="row mt-3">
                    @foreach($complaint->images as $image)
                    <div class="col-md-3 mb-3">
                        <a href="{{ storage_url( $image) }}" target="_blank">
                            <img src="{{ storage_url( $image) }}" alt="Complaint Image" class="img-thumbnail" style="width: 100%; height: 200px; object-fit: cover;">
                        </a>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.quick_actions') }}</h5>
            </div>
            <div class="card-body">
                @can('quality.complaints.update')
                    @if(!$complaint->isResolved())
                        <form action="{{ route('quality.complaints.update', $complaint) }}" method="POST" class="mb-2">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="resolved">
                            <input type="hidden" name="resolved_date" value="{{ date('Y-m-d') }}">
                            <button type="submit" class="btn btn-success w-100">
                                <i class="bi bi-check-circle"></i> {{ trans('messages.mark_as_resolved') }}
                            </button>
                        </form>
                    @endif
                @endcan
            </div>
        </div>
    </div>
</div>
@endsection

