@extends('layouts.master')

@section('title', trans('messages.defect_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.defect_details') }}: {{ $defect->defect_number }}</h2>
    <div>
        @can('quality.defects.update')
            <a href="{{ route('quality.defects.edit', $defect) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        @endcan
        <a href="{{ route('quality.defects.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <h4>{{ $defect->defect_number }}</h4>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.product') }}:</strong> 
                            <a href="{{ route('products.show', $defect->product) }}">{{ $defect->product->name }}</a>
                        </p>
                        @if($defect->warehouse)
                        <p><strong>{{ trans('messages.warehouse') }}:</strong> 
                            {{ app()->getLocale() === 'ar' && $defect->warehouse->name_ar ? $defect->warehouse->name_ar : $defect->warehouse->name }}
                        </p>
                        @endif
                        @if($defect->purchaseInvoice)
                        <p><strong>{{ trans('messages.purchase_invoice') }}:</strong> 
                            <a href="{{ route('purchase-invoices.show', $defect->purchaseInvoice) }}">{{ $defect->purchaseInvoice->invoice_number }}</a>
                        </p>
                        @endif
                        @if($defect->batch)
                        <p><strong>{{ trans('messages.batch_number') }}:</strong> {{ $defect->batch->batch_number }}</p>
                        @endif
                        <p><strong>{{ trans('messages.defect_type') }}:</strong> {{ trans('messages.defect_type_' . $defect->defect_type) }}</p>
                        <p><strong>{{ trans('messages.quantity') }}:</strong> {{ number_format($defect->quantity) }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.severity') }}:</strong> 
                            <span class="badge bg-{{ $defect->getSeverityBadgeClass() }}">
                                {{ trans('messages.severity_' . $defect->severity) }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            <span class="badge bg-{{ $defect->getStatusBadgeClass() }}">
                                {{ trans('messages.status_' . $defect->status) }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.reported_date') }}:</strong> {{ $defect->reported_date->format('Y-m-d') }}</p>
                        @if($defect->resolved_date)
                        <p><strong>{{ trans('messages.resolved_date') }}:</strong> {{ $defect->resolved_date->format('Y-m-d') }}</p>
                        @endif
                        <p><strong>{{ trans('messages.reported_by') }}:</strong> {{ $defect->reportedBy->name }}</p>
                        @if($defect->assignedTo)
                        <p><strong>{{ trans('messages.assigned_to') }}:</strong> {{ $defect->assignedTo->name }}</p>
                        @endif
                    </div>
                </div>

                <hr>

                <div class="mb-3">
                    <strong>{{ trans('messages.description') }}:</strong>
                    <p>{{ $defect->description }}</p>
                </div>

                @if($defect->description_ar)
                <div class="mb-3">
                    <strong>{{ trans('messages.description_ar') }}:</strong>
                    <p>{{ $defect->description_ar }}</p>
                </div>
                @endif

                @if($defect->resolution_notes)
                <div class="mb-3">
                    <strong>{{ trans('messages.resolution_notes') }}:</strong>
                    <p>{{ $defect->resolution_notes }}</p>
                </div>
                @endif

                @if($defect->images && count($defect->images) > 0)
                <hr>
                <strong>{{ trans('messages.images') }}:</strong>
                <div class="row mt-3">
                    @foreach($defect->images as $image)
                    <div class="col-md-3 mb-3">
                        <a href="{{ storage_url($image) }}" target="_blank">
                            <img src="{{ storage_url($image) }}" alt="Defect Image" class="img-thumbnail" style="width: 100%; height: 200px; object-fit: cover;">
                        </a>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.quick_actions') }}</h5>
            </div>
            <div class="card-body">
                @can('quality.defects.update')
                    @if(!$defect->isResolved())
                        <form action="{{ route('quality.defects.update', $defect) }}" method="POST" class="mb-2">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="resolved">
                            <input type="hidden" name="resolved_date" value="{{ date('Y-m-d') }}">
                            <button type="submit" class="btn btn-success w-100">
                                <i class="bi bi-check-circle"></i> {{ trans('messages.mark_as_resolved') }}
                            </button>
                        </form>
                    @endif
                @endcan
            </div>
        </div>
    </div>
</div>
@endsection

