@extends('layouts.master')

@section('title', trans('messages.quality_reports'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.quality_reports') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('quality.defects.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<form method="GET" action="{{ route('quality.reports.index') }}" class="card mb-4">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-5">
                <label for="date_from" class="form-label">{{ trans('messages.date_from') }}</label>
                <input type="date" class="form-control" id="date_from" name="date_from" value="{{ $dateFrom }}">
            </div>
            <div class="col-md-5">
                <label for="date_to" class="form-label">{{ trans('messages.date_to') }}</label>
                <input type="date" class="form-control" id="date_to" name="date_to" value="{{ $dateTo }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">{{ trans('messages.filter') }}</button>
            </div>
        </div>
    </div>
</form>

<!-- Defects Statistics -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5>{{ trans('messages.total_defects') }}</h5>
                <h3>{{ $totalDefects }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.resolved_defects') }}</h5>
                <h3>{{ $resolvedDefects }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5>{{ trans('messages.critical_defects') }}</h5>
                <h3>{{ $criticalDefects }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.avg_resolution_time') }}</h5>
                <h3>{{ $avgResolutionTime && $avgResolutionTime->avg_days ? number_format($avgResolutionTime->avg_days, 1) : '0' }} {{ trans('messages.days') }}</h3>
            </div>
        </div>
    </div>
</div>

<!-- Complaints Statistics -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_complaints') }}</h5>
                <h3>{{ $totalComplaints }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.resolved_complaints') }}</h5>
                <h3>{{ $resolvedComplaints }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5>{{ trans('messages.critical_complaints') }}</h5>
                <h3>{{ $criticalComplaints }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.avg_resolution_time') }}</h5>
                <h3>{{ $avgComplaintResolutionTime && $avgComplaintResolutionTime->avg_days ? number_format($avgComplaintResolutionTime->avg_days, 1) : '0' }} {{ trans('messages.days') }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.defects_by_type') }}</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.defect_type') }}</th>
                            <th class="text-end">{{ trans('messages.count') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($defectsByType as $item)
                        <tr>
                            <td>{{ trans('messages.defect_type_' . $item->defect_type) }}</td>
                            <td class="text-end">{{ $item->count }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.complaints_by_type') }}</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.complaint_type') }}</th>
                            <th class="text-end">{{ trans('messages.count') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($complaintsByType as $item)
                        <tr>
                            <td>{{ trans('messages.complaint_type_' . $item->complaint_type) }}</td>
                            <td class="text-end">{{ $item->count }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.products_with_most_defects') }}</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.product') }}</th>
                            <th class="text-end">{{ trans('messages.defect_count') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($productsWithDefects as $item)
                        <tr>
                            <td>{{ $item->product->name }}</td>
                            <td class="text-end">{{ $item->defect_count }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">{{ trans('messages.no_data') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.products_with_most_complaints') }}</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.product') }}</th>
                            <th class="text-end">{{ trans('messages.complaint_count') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($productsWithComplaints as $item)
                        <tr>
                            <td>{{ $item->product->name }}</td>
                            <td class="text-end">{{ $item->complaint_count }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">{{ trans('messages.no_data') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.quality_reports')])
@endsection

