@extends('layouts.master')

@section('title', trans('messages.quotation') . ' #' . $invoice->invoice_number)

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.quotation') }} #{{ $invoice->invoice_number }}</h2>
    <div>
        @can('invoices.update')
            @if($invoice->isDraft())
                <a href="{{ route('quotations.edit', $invoice) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
            @endif
        @endcan
        @can('invoices.finalize')
            @if($invoice->isDraft())
                <form action="{{ route('invoices.convert-quotation-to-invoice', $invoice) }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-success" onclick="return confirm('{{ trans('messages.confirm_convert_quotation_to_invoice') }}')">
                        <i class="bi bi-receipt"></i> {{ trans('messages.convert_to_invoice') }}
                    </button>
                </form>
            @endif
        @endcan
        <a href="{{ route('invoices.devis', $invoice) }}" class="btn btn-primary" target="_blank">
            <i class="bi bi-printer"></i> {{ trans('messages.print_quotation') }}
        </a>
        @can('invoices.delete')
            @if($invoice->isDraft())
                <form action="{{ route('quotations.destroy', $invoice) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                    </button>
                </form>
            @endif
        @endcan
        <a href="{{ route('quotations.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $isRTL = app()->getLocale() === 'ar';
@endphp

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6 invoice-logo-container">
                        @if($storeLogo)
                            <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}" class="invoice-logo">
                        @else
                            <h4>{{ $storeName }}</h4>
                        @endif
                    </div>
                    <div class="col-md-6 {{ $isRTL ? 'text-start' : 'text-end' }}">
                        <h4>{{ trans('messages.quotation') }}</h4>
                        <p><strong>{{ trans('messages.quotation_number') }}:</strong> {{ $invoice->invoice_number }}</p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.customer') }}:</strong> {{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
                        @if($invoice->customer)
                            <p><strong>{{ trans('messages.email') }}:</strong> {{ $invoice->customer->email ?? 'N/A' }}</p>
                            <p><strong>{{ trans('messages.phone') }}:</strong> {{ $invoice->customer->phone ?? 'N/A' }}</p>
                        @endif
                    </div>
                    <div class="col-md-6 {{ $isRTL ? 'text-start' : 'text-end' }}">
                        <p><strong>{{ trans('messages.date') }}:</strong> {{ $invoice->created_at->format('Y-m-d H:i') }}</p>
                        <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $invoice->user->name }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.items') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th>{{ trans('messages.quantity') }}</th>
                                <th>{{ trans('messages.unit_price') }}</th>
                                <th>{{ trans('messages.tax') }}</th>
                                <th>{{ trans('messages.discount') }}</th>
                                <th>{{ trans('messages.total') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice->items as $item)
                            <tr>
                                <td>{{ $item->product->name }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>{{ format_currency($item->unit_price) }}</td>
                                <td>{{ format_currency($item->tax) }}</td>
                                <td>{{ format_currency($item->discount) }}</td>
                                <td>{{ format_currency($item->total) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="5" class="text-end">{{ trans('messages.subtotal') }}:</th>
                                <th>{{ format_currency($invoice->subtotal) }}</th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">{{ trans('messages.discount') }}:</th>
                                <th>{{ format_currency($invoice->discount) }}</th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">{{ trans('messages.tax') }}:</th>
                                <th>{{ format_currency($invoice->tax) }}</th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">{{ trans('messages.total') }}:</th>
                                <th>{{ format_currency($invoice->total) }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

