@extends('layouts.master')

@section('title', trans('messages.cash_flow_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.cash_flow_report') }}</h2>
    <div>
        <a href="{{ route('reports.cash-flow.print', request()->all()) }}" target="_blank" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </a>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.cash-flow') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.cash_inflow') }}</h5>
                <h3>{{ format_currency($totalInflow) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5>{{ trans('messages.cash_outflow') }}</h5>
                <h3>{{ format_currency($totalOutflow) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white {{ $netCashFlow >= 0 ? 'bg-primary' : 'bg-warning' }}">
            <div class="card-body">
                <h5>{{ trans('messages.net_cash_flow') }}</h5>
                <h3>{{ format_currency($netCashFlow) }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.cash_flow_report') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.date') }}</th>
                        <th class="text-end">{{ trans('messages.cash_inflow') }}</th>
                        <th class="text-end">{{ trans('messages.cash_outflow') }}</th>
                        <th class="text-end">{{ trans('messages.net_cash_flow') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($cashFlow as $flow)
                    <tr>
                        <td>{{ \Carbon\Carbon::parse($flow['date'])->format('Y-m-d') }}</td>
                        <td class="text-end text-success">{{ format_currency($flow['inflow']) }}</td>
                        <td class="text-end text-danger">{{ format_currency($flow['outflow']) }}</td>
                        <td class="text-end {{ $flow['net'] >= 0 ? 'text-success' : 'text-danger' }}">
                            {{ format_currency($flow['net']) }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.cash_flow_report')])
@endsection

