@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.cost_analysis_report') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #fff;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        
        .summary-item {
            text-align: center;
        }
        
        .summary-item h4 {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .summary-item .value {
            font-size: 20px;
            font-weight: bold;
            color: #333;
        }
        
        .summary-item.primary .value {
            color: #0d6efd;
        }
        
        .summary-item.danger .value {
            color: #dc3545;
        }
        
        .summary-item.success .value {
            color: #28a745;
        }
        
        .summary-item.info .value {
            color: #17a2b8;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        
        thead {
            background-color: #343a40;
            color: white;
        }
        
        th, td {
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            border: 1px solid #dee2e6;
        }
        
        th {
            font-weight: bold;
            font-size: 14px;
        }
        
        td {
            font-size: 13px;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        tfoot {
            background-color: #e7f1ff;
            font-weight: bold;
        }
        
        .text-right {
            text-align: {{ $isRTL ? 'left' : 'right' }} !important;
        }
        
        .text-center {
            text-align: center;
        }
        
        .print-actions {
            margin-bottom: 20px;
            text-align: center;
        }
        
        .print-actions button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 0 10px;
        }
        
        .print-actions button:hover {
            background-color: #0b5ed7;
        }
        
        @media print {
            .print-actions {
                display: none;
            }
            
            @page {
                size: landscape;
                margin: 10mm;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="print-actions">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-secondary" style="margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
            <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
        </button>
    </div>

    <div class="header">
        <div class="logo-container">
            @if($storeLogo)
                <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="report-info">
            <h2>{{ trans('messages.cost_analysis_report') }}</h2>
            <p>{{ trans('messages.from_date') }}: {{ $dateFrom }}</p>
            <p>{{ trans('messages.to_date') }}: {{ $dateTo }}</p>
            <p>
                {{ trans('messages.group_by') }}: 
                @if($groupBy === 'product')
                    {{ trans('messages.by_product') }}
                @elseif($groupBy === 'category')
                    {{ trans('messages.by_category') }}
                @else
                    {{ trans('messages.by_supplier') }}
                @endif
            </p>
            <p>{{ trans('messages.date') }}: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
    </div>

    <div class="summary">
        <div class="summary-item primary">
            <h4>{{ trans('messages.total_revenue') }}</h4>
            <div class="value">{{ format_currency($totalRevenue) }}</div>
        </div>
        <div class="summary-item danger">
            <h4>{{ trans('messages.total_cost') }}</h4>
            <div class="value">{{ format_currency($totalCost) }}</div>
        </div>
        <div class="summary-item success">
            <h4>{{ trans('messages.total_profit') }}</h4>
            <div class="value">{{ format_currency($totalProfit) }}</div>
        </div>
        <div class="summary-item info">
            <h4>{{ trans('messages.profit_margin') }}</h4>
            <div class="value">{{ number_format($profitMargin, 2) }}%</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                @if($groupBy === 'product')
                    <th>{{ trans('messages.product') }}</th>
                    <th class="text-right">{{ trans('messages.quantity') }}</th>
                    <th class="text-right">{{ trans('messages.average_cost') }}</th>
                @elseif($groupBy === 'category')
                    <th>{{ trans('messages.category') }}</th>
                    <th class="text-right">{{ trans('messages.items_count') }}</th>
                    <th class="text-right">{{ trans('messages.quantity') }}</th>
                @else
                    <th>{{ trans('messages.supplier') }}</th>
                    <th class="text-right">{{ trans('messages.invoice_count') }}</th>
                    <th class="text-right">{{ trans('messages.quantity') }}</th>
                @endif
                <th class="text-right">{{ trans('messages.total_cost') }}</th>
                <th class="text-right">{{ trans('messages.percentage') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($costBreakdown as $item)
            <tr>
                @if($groupBy === 'product')
                    <td>
                        <strong>{{ $item['product']->name ?? $item['product']->name_ar ?? trans('messages.unknown') }}</strong>
                        @if(isset($item['product']) && $item['product']->category)
                            <br><small class="text-muted">{{ $item['product']->category->name }}</small>
                        @endif
                    </td>
                    <td class="text-right">{{ number_format($item['quantity']) }}</td>
                    <td class="text-right">{{ format_currency($item['average_cost']) }}</td>
                @elseif($groupBy === 'category')
                    <td><strong>{{ $item['category'] }}</strong></td>
                    <td class="text-right">{{ number_format($item['item_count']) }}</td>
                    <td class="text-right">{{ number_format($item['quantity']) }}</td>
                @else
                    <td><strong>{{ $item['supplier'] }}</strong></td>
                    <td class="text-right">{{ number_format($item['invoice_count']) }}</td>
                    <td class="text-right">{{ number_format($item['quantity']) }}</td>
                @endif
                <td class="text-right"><strong>{{ format_currency($item['total_cost']) }}</strong></td>
                <td class="text-right">
                    {{ $totalCost > 0 ? number_format(($item['total_cost'] / $totalCost) * 100, 2) : 0 }}%
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="5" class="text-center">{{ trans('messages.no_data') }}</td>
            </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr>
                <th colspan="{{ $groupBy === 'product' ? '3' : '3' }}">{{ trans('messages.total') }}</th>
                <th class="text-right">{{ format_currency($totalCost) }}</th>
                <th class="text-right">100%</th>
            </tr>
        </tfoot>
    </table>
</body>
</html>

