@extends('layouts.master')

@section('title', trans('messages.advanced_reports'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.advanced_reports') }}</h2>
</div>

<div class="row g-3">
    <!-- Financial Reports -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-cash-coin"></i> {{ trans('messages.financial_reports') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.cash-flow') }}" class="text-decoration-none">
                            <i class="bi bi-arrow-left-right"></i> {{ trans('messages.cash_flow_report') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.profit-loss') }}" class="text-decoration-none">
                            <i class="bi bi-graph-up-arrow"></i> {{ trans('messages.profit_loss_report') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.balance-sheet') }}" class="text-decoration-none">
                            <i class="bi bi-file-earmark-spreadsheet"></i> {{ trans('messages.balance_sheet_report') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.cost-analysis') }}" class="text-decoration-none">
                            <i class="bi bi-calculator"></i> {{ trans('messages.cost_analysis_report') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Sales Reports -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-cart-check"></i> {{ trans('messages.sales_reports') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.sales') }}" class="text-decoration-none">
                            <i class="bi bi-receipt"></i> {{ trans('messages.sales_report_title') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.sales.periodic') }}" class="text-decoration-none">
                            <i class="bi bi-calendar-range"></i> {{ trans('messages.periodic_sales_report') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Supplier Reports -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-truck"></i> {{ trans('messages.supplier_reports') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.suppliers', ['type' => 'best']) }}" class="text-decoration-none">
                            <i class="bi bi-trophy"></i> {{ trans('messages.best_suppliers') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.suppliers', ['type' => 'worst']) }}" class="text-decoration-none">
                            <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.worst_suppliers') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Customer Reports -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0"><i class="bi bi-people"></i> {{ trans('messages.customer_reports') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.customers', ['type' => 'best']) }}" class="text-decoration-none">
                            <i class="bi bi-trophy"></i> {{ trans('messages.best_customers') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.customers', ['type' => 'worst']) }}" class="text-decoration-none">
                            <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.worst_customers') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Product Reports -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-secondary text-white">
                <h5 class="mb-0"><i class="bi bi-box-seam"></i> {{ trans('messages.product_reports') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.products') }}" class="text-decoration-none">
                            <i class="bi bi-graph-up"></i> {{ trans('messages.product_reports') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.product-movement') }}" class="text-decoration-none">
                            <i class="bi bi-arrow-left-right"></i> {{ trans('messages.product_movement_report') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.stagnant-products') }}" class="text-decoration-none">
                            <i class="bi bi-hourglass-split"></i> {{ trans('messages.stagnant_products_report') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Other Reports -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-dark text-white">
                <h5 class="mb-0"><i class="bi bi-list-ul"></i> {{ trans('messages.other') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.profit') }}" class="text-decoration-none">
                            <i class="bi bi-cash-stack"></i> {{ trans('messages.profit_report') }}
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a href="{{ route('reports.stock') }}" class="text-decoration-none">
                            <i class="bi bi-clipboard-data"></i> {{ trans('messages.stock_report') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Warehouse Reports (Only if multiple warehouses mode is enabled) -->
    @if(\App\Services\StockManager::isMultipleWarehouses())
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-boxes"></i> {{ trans('messages.warehouse_reports') }}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <a href="{{ route('reports.warehouses') }}" class="text-decoration-none">
                            <i class="bi bi-building"></i> {{ trans('messages.warehouses_report') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

