@extends('layouts.master')

@section('title', trans('messages.product_reports'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.product_reports') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.products') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>{{ trans('messages.product') }}</th>
                        <th class="text-end">{{ trans('messages.quantity_sold') }}</th>
                        <th class="text-end">{{ trans('messages.total_revenue') }}</th>
                        <th class="text-end">{{ trans('messages.total_cost') }}</th>
                        <th class="text-end">{{ trans('messages.profit') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productSalesPaginator as $sale)
                    <tr>
                        <td>
                            <a href="{{ route('products.show', $sale['product']->id) }}">
                                {{ $sale['product']->name }}
                            </a>
                        </td>
                        <td class="text-end">{{ $sale['quantity_sold'] }}</td>
                        <td class="text-end">{{ format_currency($sale['total_revenue']) }}</td>
                        <td class="text-end">{{ format_currency($sale['total_cost']) }}</td>
                        <td class="text-end"><strong>{{ format_currency($sale['total_revenue'] - $sale['total_cost']) }}</strong></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if(method_exists($productSalesPaginator, 'links'))
            <div class="card-footer">
                {{ $productSalesPaginator->links() }}
            </div>
        @endif
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.product_reports')])
@endsection

